/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import collection.At;
import context.Context;
import iterator.CollectIterator;
import iterator.ScopedContextIterator;
import iterator.SelectIterator;
import java.util.Iterator;
import mapping.Mapping;
import mapping.WMapping;
import mapping.o;

/**
 * Context Select
 * @author mtomono
 */
public class Select<T> extends WMapping<Iterator<T>, Iterator<T>>{
    Mapping<? super Context<T>, Boolean> condition;
    Mapping<? super Context<T>, T> mapping;
    int size;
    
    public Select(Mapping<? super T, Boolean> condition) {
        this(new o<Context<? super T>, T, Boolean>(condition, At.NOW), At.NOW, 1);
    }
    public Select(Mapping<? super Context<T>, Boolean> condition, Mapping<? super Context<T>, T> mapping, int size) {
        this.condition = condition;
        this.mapping = mapping;
        this.size = size;
    }
    
    @Override
    public Iterator<T> of(Iterator<T> target) {
        return new CollectIterator<>(new SelectIterator<>(new ScopedContextIterator<>(target, 0, size), condition), mapping);
    }
}
