/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import context.IContext;
import iterator.*;
import mapping.Matches;
import mapping.WMapping;
import parser.Grammar;
import parser.ParseLength;

/**
 *
 * @author mtomono
 */
public class PatternDivided<T> extends WMapping<UnreadableIterator<IContext<T>>, DividedIterator<T>>  {
    Grammar<T> grammar;
    
    public PatternDivided(Grammar<T> grammar) {
        this.grammar = grammar;
    }
    
    @Override
    public DividedIterator<T> of(UnreadableIterator<IContext<T>> target) {
        UntilIterator<IContext<T>> until = new UntilIterator<>(target, new Matches<>(grammar));
        return new DividedIterator(new CollectIterator<>(until, new Next<T>()), new DivideController<>(target, new ParseLength(grammar)));
    }
}
