/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import iterator.CollectIterator;
import iterator.ScopedIContextIterator;
import iterator.SelectIterator;
import java.util.Iterator;
import java.util.Map;
import mapping.Matches;
import mapping.WMapping;
import parser.Grammar;
import parser.ParseBody;

/**
 *
 * @author mtomono
 */
public class Pattern<IN, OUT> extends WMapping<Iterator<IN>, Iterator<OUT>> {
    Grammar<IN> grammar;
    int fore;
    int pre;
    Map<String, ?> values;
    
    public Pattern(Grammar<IN> grammar, int fore, int pre, Map<String, ?> values) {
        this(grammar, fore, pre);
        this.values = values;
    }
    
    public Pattern(Grammar<IN> grammar, int fore, int pre) {
        this.grammar = grammar;
        this.fore = fore;
        this.pre = pre;
        this.values = null;
    }
    
    @Override
    public Iterator<OUT> of(Iterator<IN> target) {
        return new CollectIterator<>(
            new SelectIterator<>(
                new ScopedIContextIterator<>(target, fore, pre).setValues(values), 
                new Matches<>(grammar)), 
            new ParseBody<IN, OUT>(grammar));
    }
    
}
