/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator.mapping;

import collection.At;
import context.Context;
import iterator.CollectIterator;
import iterator.ScopedContextIterator;
import java.util.Iterator;
import mapping.Mapping;
import mapping.WMapping;
import mapping.o;

/**
 *
 * @author mtomono
 */
public class Collect<IN, OUT> extends WMapping<Iterator<IN>, Iterator<OUT>> {
    int size;
    Mapping<? super Context<IN>, ? extends OUT> mapping;
    
    public Collect(Mapping<? super IN, ? extends OUT> body) {
        this(new o<Context<? super IN>, IN, OUT>(body, At.NOW), 1);
    }
    
    public Collect(Mapping<? super Context<IN>, ? extends OUT> mapping, int size) {
        this.mapping = mapping;
        this.size = size;
    }
    
    @Override
    public Iterator<OUT> of(Iterator<IN> target) {
        return new CollectIterator<>(new ScopedContextIterator<>(target, 0, size), mapping);
    }
}
