/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class UntilIterator<T> extends AbstractIterator<T> {
    Mapping<? super T, Boolean> terminator;
    UnreadableIterator<T> body;
    
    public UntilIterator(UnreadableIterator<T> body, Mapping<? super T, Boolean> terminator) {
        this.body = body;
        this.terminator = terminator;
    }
    
    @Override
    protected void findNext() {
        if (!body.hasNext())
            return;
        T current = body.next();
        if (!terminator.of(current)) {
            nextFound(current);
        } else {
            body.unread();
        }
    }
}
