/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import context.Context;
import java.util.Iterator;
import java.util.Map;

/**
 *
 * @author mtomono
 */
public class ScopedContextIterator<T> implements Iterator<Context<T>> {
    ScopedIterator<T> body;
    Context<T> context;
    
    public ScopedContextIterator(Iterator<T> body, int fore, int pre) {
        this(new ScopedIterator<>(body, fore, pre));
    }
    
    public ScopedContextIterator(ScopedIterator<T> body) {
        this.body = body;
        this.context = new Context<>(this.body.scope());
    }
    
    public ScopedContextIterator<T> setValues(Map<String, Object> values) {
        this.context.setValues(values);
        return this;
    }

    @Override
    public boolean hasNext() {
        return body.hasNext();
    }

    @Override
    public Context<T> next() {
        body.next();
        return context;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
