                                                                                        /*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import collection.At;
import collection.view.ReverseView;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class MultiUnreadableIterator<T> extends UnreadableIterator<T> {
    Iterator<T> body;
    List<T> buffer;
    ListIterator<Mapping<List<T>, T>> observer;
    
    public MultiUnreadableIterator(Iterator<T> body, int depth) {
        this(new PrefetchedIterator<>(body, depth));
    }
    
    public MultiUnreadableIterator(PrefetchedIterator<T> body) {
        this.body = body;
        this.buffer = new ReverseView<>(body.pre());
        this.observer = At.<T>batch(0, body.getDepth()).listIterator();
    }
    
    @Override
    public boolean unread() {
        if (observer.hasNext()) {
            Mapping<List<T>, T> map = observer.next();
            if (!map.isReady(buffer))
                observer.previous();
            return map.isReady(buffer);
        }
        return false;
    }
    
    @Override
    public boolean hasNext() {
        return observer.hasPrevious() || body.hasNext();
    }

    @Override
    public T next() {
        if (observer.hasPrevious())
            return observer.previous().of(buffer);
        else
            return body.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
}
