/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 *
 * @author mtomono
 */
public class LimitedIterator<T> implements Iterator<T> {
    Iterator<T> body;
    int count;
    
    public LimitedIterator(Iterator<T> body, int limit) {
        this.body = body;
        this.count = limit;
    }
    
    @Override
    public boolean hasNext() {
        return count > 0 && body.hasNext();
    }

    @Override
    public T next() {
        if (count-- <= 0)
            throw new NoSuchElementException("LimitedIterator#next() : gone beyond the limit");
        return body.next();
    }

    @Override
    public void remove() {
        body.remove();
    }
}
