/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import collection.c;
import java.util.Iterator;
import java.util.List;
import mapping.IsReady;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class Iterators {
    
    public static <T> Iterator pushBack(Iterator<T> body, T... pushed) {
        return new ConcatIterator(c.a2i(c.a2i(pushed), body));
    }
    
    public static <T> Iterator<T> append(Iterator<T> body, T... pushed) {
        return new ConcatIterator<>(c.a2i(body, c.a2i(pushed)));
    }
    
    public static <T> void addToList(Iterator<T> body, List<T> list) {
        while (body.hasNext()) {
            list.add(body.next());
        }
    }
    
    public static <S, T> SelectIterator<S> selectReady(Iterator<? extends S> body, Mapping<? super S, ? extends T> mapping) {
        return new SelectIterator<>(body, new IsReady<>(mapping));
    }
}
