/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import iterator.driver.FinalValue;
import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class DividedIterator<T> implements Iterator<T> {
    Iterator<T> body;
    DivideController<?> controller;
    FinalValue<T> driver;
    
    public DividedIterator(Iterator<T> body, DivideController<?> controller) {
        this.body = body;
        this.controller = controller;
    }
    
    @Override
    public boolean hasNext() {
        return this.body.hasNext();
    }

    @Override
    public T next() {
        return this.body.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    public boolean resume() {
        return controller.resume();
    }
    
    public boolean skip() {
        driver.of(body);
        return resume();
    }
    
    public DivideController<?> getController() {
        return controller;
    }
    
    public boolean isTerminated() {
        return !body.hasNext() && controller.hasNext();
    }
}
