/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import collection.view.StraightView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/**
 *
 * @author mtomono
 */
public class CacheIterator<T> extends StraightView<T> implements Iterator<T>{
    List<T> cache;
    Iterator<T> body;
    int index;
    
    public CacheIterator(Iterator<T> body) {
        this(body, new ArrayList<T>());
    }
    
    private CacheIterator(Iterator<T> body, ArrayList<T> cache) {
        super(cache);
        this.body = body;
        this.cache = cache;
        this.index = 0;
    }
    
    @Override
    public T get(int at) {
        for (int i = cache.size(); i <= at; i++) {
            if (!body.hasNext())
                throw new NoSuchElementException("CacheIterator#get() : gone beyond boundary");
            cache.add(body.next());
        }
        return super.get(at);
    }
    
    public void refresh() {
        index = 0;
    }
    
    public List<T> dump() {
        return cache;
    }
    
    @Override
    public boolean hasNext() {
        return index < cache.size() || body.hasNext();
    }

    @Override
    public T next() {
        if (index >= cache.size())
            cache.add(body.next());
        return cache.get(index++);
    }
    
    @Override
    public Iterator<T> iterator() {
        return new DedicatedIterator<>(this);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    class DedicatedIterator<T> implements Iterator<T> {
        int index;
        CacheIterator<T> body;
        
        public DedicatedIterator(CacheIterator<T> body) {
            this.index = 0;
            this.body = body;
        }
        
        @Override
        public boolean hasNext() {
            return index < body.cache.size() || body.body.hasNext();
        }

        @Override
        public T next() {
            return body.get(index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        
    }
}
