/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package container;

import container.Container;
import mapping.Mapping;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class MappedContainer<IN, OUT>implements Container<OUT> {
    Container<IN> body;
    Mapping<IN, OUT> mapping;
    
    public MappedContainer(Container<IN> body, Mapping<IN, OUT> mapping) {
        this.body = body;
        this.mapping = mapping;
    }
    
    @Override
    public OUT value() {
        return mapping.of(body.value());
    }

    @Override
    public boolean isReady() {
        return body.isReady();
    }
    
    @Override
    public String toString() {
        return "(" + this.body.toString() + "->" + mapping.toString() + ")";
    }
}
