/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package container;

import mapping.Mapping;
import mapping.order.Compare;
import mapping.order.Default;
import mapping.order.Order;

/**
 * CC stands for Container Compare
 * @author mtomono
 */
public class CC<T extends Comparable<T>> implements Mapping<T, Boolean> {
    Compare<T> body;
    Container<T> norm;
    Order order;

    public CC(Compare<T> body, Container<T> norm, Order order) {
        this.body = body;
        this.norm = norm;
        this.order = order;
    }
    
    public CC(Compare<T> body, T norm, Order order) {
        this(body, new Constant(norm), order);
    }
    
    public CC(Compare<T> body, Container<T> norm) {
        this(body, norm, Default.order);
    }
    
    public CC(Compare<T> body, T norm) {
        this(body, norm, Default.order);
    }
    
    public boolean isReady() {
        return this.norm.isReady();
    }
    
    protected boolean ifNotReady() {
        return true;
    }
    
    @Override
    public Boolean of(T target) {
        if (isReady()) 
            return body.compare(order, target, this.norm.value());
        else
            return ifNotReady();
    }
    
    @Override
    public String toString() {
        return "X" + body.toString() + norm.toString();
    }

    @Override
    public boolean isReady(T target) {
        return isReady();
    }
}
