/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package collection.view;

import collection.ToIterator;
import collection.ToSize;
import iterator.CollectIterator;
import iterator.ConcatIterator;
import iterator.ScopedIterator;
import iterator.driver.FinalValue;
import iterator.mapping.AccumulateInject;
import iterator.mapping.Inject;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/**
 *
 * @author mtomono
 */
public class ConcatView<T> extends AbstractList<T> {
    List<List<T>> body;
    
    public ConcatView(List<List<T>> body) {
        this.body = body;
    }
    
    @Override
    public Iterator<T> iterator() {
        return new ConcatIterator<>(new CollectIterator<>(body.iterator(), new ToIterator<T>()));
    }
    
    public ScopedIterator<Number> sizeIterator(Iterator<List<T>> baseIter) {
        return new Inject<>(1, AccumulateInject.<Integer>c(), 0).of(new CollectIterator<List<T>, Integer>(baseIter, new ToSize()));
    }
    
    @Override
    public T get(int index) {
        ScopedIterator<List<T>> baseIter = new ScopedIterator<>(body.iterator(), 0, 1);
        ScopedIterator<Number> iter = sizeIterator(baseIter);
        while (iter.hasNext()) {
            if ((Integer)iter.next() > index)
                    return baseIter.scope().get(0).get(index - (Integer)iter.scope().get(-1));
        }
        throw new NoSuchElementException("ConcatView#get : index gone out of range");
    }

    @Override
    public int size() {
        return (int)new FinalValue<Number>().of(sizeIterator(body.iterator()));
    }
}
