/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package collection;

import java.util.ArrayList;

/**
 *
 * @author mtomono
 */
public class SizedRingBuffer<T> extends RingBuffer<T> {
    int limit;
    public SizedRingBuffer(int limit) {
        super(new ArrayList<T>(limit));
        this.limit = limit;
    }
    
    public int getLimit() {
        return this.limit;
    }
    
    @Override
    public T push(T obj) {
        if (size() < limit) {
            super.add(obj);
            return get(0);
        } else {
            return super.push(obj);
        }
    }
    
    @Override
    public boolean add(T obj) {
        if (size() == limit) {
            return false;
        }
        return super.add(obj);
    }
    
    @Override
    public void add(int at, T obj) {
        if (size() == limit) {
            return;
        }
        super.add(at, obj);
    }
}
