/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package bitmap;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author mtomono
 */
public class ReferenceMap<T> extends AbstractList<T> {
    ArrayList<T> body;
    Map<T, Integer> index;

    public ReferenceMap() {
        this.body = new ArrayList<>();
        this.index = new HashMap<>();
    }
    
    @Override 
    public boolean add(T o) {
        if (index.containsKey(o))
            return false;
        body.add(o);
        index.put(o, body.size() - 1);
        return true;
    }
    
    @Override
    public boolean contains(Object o) {
        return index.containsKey((T)o);
    }
    
    @Override
    public T get(int index) {
        return body.get(index);
    }

    @Override
    public int size() {
        return body.size();
    }
    
    public int resolve(T o) {
        return index.get(o);
    }
    
    public T resolve(int index) {
        return body.get(index);
    }
}
