/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package arithmetic;

import java.util.List;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class Div<T extends Number> implements Mapping<List<T>, Number> {
    
    @Override
    public Number of(List<T> target) {
        assert target.size() == 2;
        assert target.get(0) != null;
        assert target.get(1) != null;
        assert target.get(0) instanceof Number;
        assert target.get(1) instanceof Number;
        if (target.get(0) instanceof Double || target.get(1) instanceof Double)
            return target.get(0).doubleValue() / target.get(1).doubleValue();
        else if (target.get(0) instanceof Long || target.get(1) instanceof Long)
            return target.get(0).longValue() / target.get(1).longValue();
        else 
            return target.get(0).intValue() / (int)target.get(1).intValue();
    }

    @Override
    public boolean isReady(List<T> target) {
        return !target.get(1).equals(0);
    }
}
