/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: task.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^XNǗW[
 */

#ifndef _TASK_H_
#define _TASK_H_

#include "queue.h"
#include "time_event.h"

/*
 *  ^XNDx̓\EO\ϊ}N
 */
#define INT_PRIORITY(x)		((UINT)((x) - TMIN_TPRI))
#define EXT_TSKPRI(x)		((PRI)(x) + TMIN_TPRI)

/*
 *  ^XNԂ̓\
 *
 *  TCB ̃^XNԂł́CsԁiRUNNINGjƎs\ԁiREADYj
 *  ͋ʂȂDԂ𑍏̂āCsłԁiRUNNABLEjƌĂԁD
 *  d҂Ԃ́C(TS_WAITING | TS_SUSPENDED) ŕ\DTS_WAIT_???? 
 *  ́C҂ԂɔtԂ\C҂ԁid҂Ԃ܂ށj
 *  ꍇɂ̂ݐݒ肳D
 */
#define	TS_DORMANT	0x00u	/* x~ */
#define	TS_RUNNABLE	0x01u	/* sł */
#define	TS_WAITING	0x02u	/* ҂ */
#define	TS_SUSPENDED	0x04u	/* ҂ */

#define	TS_WAIT_SLEEP	0x08u	/* N҂ */
#define	TS_WAIT_WOBJ	0x10u	/* EʐMIuWFNgɑ΂҂ */
#define	TS_WAIT_WOBJCB	0x20u	/* ʕ̑҂L[ɂȂĂ */

/*
 *  ^XNԔʃ}N
 *
 *  TSTAT_DORMANT ̓^XNx~Ԃł邩ǂCTSTAT_RUNNABLE 
 *  ̓^XNsłԂł邩ǂ𔻕ʂDTSTAT_WAITING 
 *  ҂ԂƓd҂Ԃ̂ꂩł邩ǂCTSTAT_SUSPENDED 
 *  ͋҂ԂƓd҂Ԃ̂ꂩł邩ǂ𔻕ʂD
 */
#define TSTAT_DORMANT(tstat)	((tstat) == TS_DORMANT)
#define TSTAT_RUNNABLE(tstat)	(((tstat) & TS_RUNNABLE) != 0)
#define TSTAT_WAITING(tstat)	(((tstat) & TS_WAITING) != 0)
#define TSTAT_SUSPENDED(tstat)	(((tstat) & TS_SUSPENDED) != 0)

/*
 *  ҂ubNiWINFOj̒`
 *
 *  ^XN҂Ԃ̊Ԃ́CTCB тw WINFO ̂
 *  ɐݒ肵Ȃ΂ȂȂD
 *
 *  (a) TCB ̃^XNԂ҂ԂɂD̍ۂɁC҂Ԃɔt
 *  ԁiTS_WAIT_????jݒ肷D
 *
 *  (b) ^CAEgĎ邽߂ɁC^CCxgubNo^D
 *  o^^CCxgubŃC҂ɓT[rXR[֐
 *  ̃[JϐƂĊmۂCւ̃|C^ WINFO  tmevtb 
 *  LD^CAEg̊ĎKvȂꍇiiv҂̏ꍇjɂ́C
 *  tmevtb  NULL ɂD
 *
 *  EʐMIuWFNgɑ΂҂Ԃ̏ꍇɂ́CW WINFO  
 *  wobjcbtB[hǉ\́iWINFO_WOBJCwait.h Œ`jg
 *  C^XNԂ TS_WAIT_WOBJ ݒ肷D܂Cȉ (c)`(e) 
 *  ݒsKvDEʐMIuWFNgɊ֌WȂ҂iN
 *  ҂CԌoߑ҂j̏ꍇɂ́C(c)`(e) ͕KvȂD
 *
 *  (c) TCB ҂Ώۂ̓EʐMIuWFNg̑҂L[ɂȂD
 *  L[ɂȂ߂ɁCtask_queue gDTCB 𓯊EʐMIuWF
 *  Ng̊ǗubN̋ʕiWOBJCBj̑҂L[ɂȂꍇ
 *  ́C^XNԂ TS_WAIT_WOBJCB ݒ肷D
 *
 *  (d) ҂Ώۂ̓EʐMIuWFNg̊ǗubNւ̃|C^C
 *  WINFO_WOBJ  wobjcb ɋLD
 *  JSPJ[l wobjcb ĝ́CDx̑҂L[ɂȂ
 *  ^XN̗DxύXꂽꍇ݂̂ł邪CfobO
 *  o₷悤ɁC҂L[DxłȂꍇɂ wobjcb ݒ
 *  D
 *
 *  (e) ҂Ώۂ̓EʐMIuWFNgɈˑċL邱ƂKv
 *  񂪂ꍇɂ́CWINFO_WOBJ ɕKvȏ̂߂̃tB[hǉ
 *  \̂`CWINFO_WOBJ ̑ɗpD
 *
 *  ҂Ԃۂɂ́C҂^XN̕Ԓl WINFO 
 *  wercd ɐݒ肷Dwercd ĝ͑҂ȍ~ł̂ɑ΂āC
 *  tmevtb ͑҂͎gȂ߁Cߖ̂߂ɋṕiunionj
 *  gĂD
 */
typedef union waiting_information {
	ER	wercd;		/* ҂̃G[R[h */
	TMEVTB	*tmevtb;	/* ҂ԗp̃^CCxgubN */
} WINFO;

/*
 *  ^XNubN
 *
 *  ^XNɊւClςȂ߂ROMɒu镔i^XN
 *  ubNjƁClω邽߂RAMɒuȂ΂ȂȂ
 *  i^XNǗubNCTCBjɕCTCBɑΉ^XN
 *  ubNw|C^D^XNubNɑΉ
 *  TCBw|C^@̕CRAM̐ߖ̊ϓ_͖]܂
 *  CsȂ邽߂ɍ̗pĂȂD̃IuWFNgɂ
 *  ĂlɈD
 *  ^XNubNɂ́CDEF_TEX Œ`^XNO[`
 *  Ɋւ܂ށD
 */
typedef struct task_initialization_block {
	ATR	tskatr;		/* ^XN */
	VP_INT	exinf;		/* ^XN̊g */
	FP	task;		/* ^XN̋NԒn */
	UINT	ipriority;	/* ^XN̋NDxi\j */
	SIZE	stksz;		/* X^bN̈̃TCYiۂ߂lj */
	VP	stk;		/* X^bN̈̐擪Ԓn */

	ATR	texatr;		/* ^XNO[` */
	FP	texrtn;		/* ^XNO[`̋NԒn */
} TINIB;

/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  TCB ̃tB[h̔zúC\ɑ傫eƎv邽߁C^[
 *  QbgˑɃtB[h̃rbgύX邱ƂĂD
 */
#ifndef TBIT_TCB_TSTAT
#define	TBIT_TCB_TSTAT		6	/* tstat tB[h̃rbg */
#endif /* TBIT_TCB_TSTAT */

#ifndef TBIT_TCB_PRIORITY
#define	TBIT_TCB_PRIORITY	4	/* priority tB[h̃rbg */
#endif /* TBIT_TCB_PRIORITY */

/*
 *  ^XNǗubNiTCBj
 *
 *  JSPł́C^XN̋NvL[CO̍őliTMAX_ACTCNTjƋN
 *  vL[CO̍őliTMAX_WUPCNTj 1 ɌŒ肳Ă邽
 *  ߁CL[COĂ邩ǂ̐^Ulŕ\邱ƂłD
 *  ܂C҂vlXg̍őliTMAX_SUSCNTj 1 ɌŒ肳
 *  ̂ŁC҂vlXgisuscntj͕KvȂD
 */
typedef struct task_control_block {
	QUEUE	task_queue;	/* ^XNL[ */
	const TINIB *tinib;	/* ^XNubNւ̃|C^ */

	unsigned int	tstat : TBIT_TCB_TSTAT;	/* ^XNԁi\j*/
	unsigned int	priority : TBIT_TCB_PRIORITY;
						/* ݂̗Dxi\j*/
	unsigned int	actcnt : 1;		/* NvL[CO */
	unsigned int	wupcnt : 1;		/* NvL[CO */
	unsigned int	enatex : 1;		/* ^XNO */

	TEXPTN	texptn;		/* ۗOv */
	WINFO	*winfo;		/* ҂ubNւ̃|C^ */
	CTXB	tskctxb;	/* ^XNReLXgubN */
} TCB;

/*
 *  sԂ̃^XN
 *
 *  sԂ̃^XNivZbTReLXgĂ^XNj
 *  TCB w|C^DsԂ̃^XNȂꍇ NULL ɂD
 *  T[rXR[̏ŁC^XNiT[rXR[Ăяo^X
 *  NjɊւQƂꍇ runtsk gDruntsk 
 *  ̂́CfBXpb`iƏĵ݂łD
 */
extern TCB	*runtsk;

/*
 *  ōD揇ʂ̃^XN
 *
 *  sł^XN̒ōōD揇ʂ̃^XN TCB w|C^D
 *  sł^XNȂꍇ NULL ɂD
 *  fBXpb`֎~ԂȂǁCfBXpb`ۗĂԂ́Cruntsk
 *  ƈvĂƂ͌ȂD
 */
extern TCB	*schedtsk;

/*
 *  fBXpb`^^XNO[`NvtO
 *
 *  ݃nh^CPUOnh̏oɁCfBXpb`܂
 *  ^XNO[`̋Nv邱ƂtOD
 */
extern BOOL	reqflg;

/*
 *  fBXpb`
 *
 *  fBXpb`ԂłiȂ킿CfBXpb`֎~ԂłȂj
 *  ƂtOD
 */
extern BOOL	enadsp;

/*
 *  fBL[
 *
 *  fBL[́CsłԂ̃^XNǗ邽߂̃L[łD
 *  sԂ̃^XNǗĂ邽߁CfBis\jL[Ƃ
 *  ̂͐mł͂ȂCfBL[Ƃ̂蒅Ă邽߁C
 *  ̖̂ŌĂԂƂɂD
 *
 *  fBL[́CDxƂ̃^XNL[ō\ĂD^XN
 *  TCB́CYDx̃L[ɓo^D
 */
extern QUEUE	ready_queue[TNUM_TPRI];

/*
 *  fBL[T[`̂߂̃rbg}bv
 *
 *  fBL[̃T[`悭s߂ɁCDxƂ̃^XNL[
 *  Ƀ^XNĂ邩ǂrbg}bvpӂĂDrb
 *  g}bvgƂŁCANZX̉񐔂炷Ƃł邪C
 *  rbg얽߂[ĂȂvZbTŁCDx̒iKȂ
 *  ꍇɂ́Crbg}bṽI[o[wbĥ߂ɁCtɌ
 *  \D
 */
extern UINT	ready_primap;

/*
 *  ^XNID̍őlikernel_cfg.cj
 */
extern const ID	tmax_tskid;

/*
 *  ^XNubÑGAikernel_cfg.cj
 */
extern const TINIB	tinib_table[];

/*
 *  ^XNe[uikernel_cfg.cj
 */
extern const ID	torder_table[];

/*
 *  TCB̃GAikernel_cfg.cj
 */
extern TCB	tcb_table[];

/*
 *  ^XN̐
 */
#define TNUM_TSK	((UINT)(tmax_tskid - TMIN_TSKID + 1))

/*
 *  ^XNIDTCBo߂̃}N
 */
#define INDEX_TSK(tskid)	((UINT)((tskid) - TMIN_TSKID))
#define get_tcb(tskid)		(&(tcb_table[INDEX_TSK(tskid)]))
#define get_tcb_self(tskid)	((tskid) == TSK_SELF ? runtsk : get_tcb(tskid))

/*
 *  TCB^XNIDo߂̃}N
 */
#define	TSKID(tcb)	((ID)(((tcb) - tcb_table) + TMIN_TSKID))

/*
 *  ^XNǗW[̏
 */
extern void	task_initialize(void);

/*
 *  ōD揇ʃ^XÑT[`
 *
 *  fBL[̍ōD揇ʂ̃^XNT[`CTCBւ̃|C^
 *  ԂDfBL[̏ꍇɂ́C̊֐ĂяoĂ͂ȂȂD
 */
extern TCB	*search_schedtsk(void);

/*
 *  słԂւ̈ڍs
 *
 *  tcb Ŏw肳^XN̏ԂsłԂƂCfBL[ɑ}
 *  DsłԂɂȂ^XN̗DxCōD揇ʂ̃^X
 *  N̗Dxꍇ́CōD揇ʂ̃^XNXVCfBXpb
 *  `Ԃł TRUE ԂDłȂꍇ FALSE ԂD
 */
extern BOOL	make_runnable(TCB *tcb);

/*
 *  słԂ瑼̏Ԃւ̈ڍs
 *
 *  tcb Ŏw肳^XNfBL[폜Dtcb Ŏw肵^
 *  XNōD揇ʂ̃^XNłꍇɂ́CōD揇ʂ̃^XN
 *  ݒ肵ȂCfBXpb`Ԃł TRUE ԂDłȂ
 *  ꍇ FALSE ԂD^XN̏Ԃ͍XVȂD
 */
extern BOOL	make_non_runnable(TCB *tcb);

/*
 *  x~Ԃւ̈ڍs
 *
 *  tcb Ŏw肳^XN̏Ԃx~ԂƂD܂C^XN̋N
 *  ɏׂϐ̏ƁC^XNN̂߂̃ReLXgݒ
 *  D
 */
extern void	make_dormant(TCB *tcb);

/*
 *  x~ԂsłԂւ̈ڍs
 *
 *  tcb Ŏw肳^XN̏Ԃx~ԂsłԂƂD
 *  słԂɈڍs^XNւ̃fBXpb`Kvȏꍇ TRUEC
 *  łȂꍇ FALSE ԂD
 */
extern BOOL	make_active(TCB *tcb);

/*
 *  sԂ̃^XN̏I
 *
 *  exit_task  ext_tsk ɖߍ܂ɕʂ̊֐ɂĂ̂́C
 *  create_context  activate_context ^XN̏IŎgp
 *  X^bNj󂵂Ȃ悤ɂ邽߂̑΍̈łDext_tsk Ƃ
 *  ʊ֐ɂĂƂŁC[Jϐ܂߂āCgpX^bN̈
 *  dȂȂ悤ɂłD܂CRpCIɃCCWJ
 *  ̂邽߂ɁCext_tsk Ƃ͕ʂ̃t@CɓĂD
 */
extern void	exit_task(void);

/*
 *  fBL[̃^XN̗Dx̕ύX
 *
 *  tcb Ŏw肳郌fBL[̃^XN̗Dx newprii\j
 *  ɕύXD܂CKvȏꍇɂ͍ōD揇ʂ̃^XNXVCfB
 *  Xpb`Ԃł TRUE ԂDłȂꍇ FALSE 
 *  D
 */
extern BOOL	change_priority(TCB *tcb, UINT newpri);

/*
 *  fBL[̉]
 *
 *  fBL[́Cpri Ŏw肳Dx̃^XNL[]D
 *  ܂CKvȏꍇɂ͍ōD揇ʂ̃^XNύXCfBXpb`
 *  ĂȂ TRUE ԂDłȂꍇ FALSE ԂD
 */
extern BOOL	rotate_ready_queue(UINT pri);

/*
 *  ^XNO[`̌ďo
 *
 *  ^XNO[`ĂяoDĂяoOɁCsԂ̃^XN
 *  ۗOvNAC^XNO֎~ԂɂCCPUbN
 *  D
 *  ^XNO[`߂ƁC܂CPUbNԂɖ߂C̊
 *  ɕۗOv 0 łȂȂĂ΁CĂу^XNO[`
 *  ĂяoDۗOv 0 ̏ꍇɂ́COԂɂĊ
 *  烊^[D
 *  ̊֐́CsԂ̃^XNC^XNOԁienatex  
 *  TRUEjŁCۗOv 0 łȂitexptn  0 łȂjꍇɌĂ
 *  oƂz肵ĂD̊֐́CCPUbNԂŌĂяoȂ
 *  ΂ȂȂD
 */
extern void	call_texrtn(void);

/*
 *  ^XNO[`̋N
 *
 *  sԂ̃^XN^XNO[`̋N𖞂Ă΁C
 *  ^XNO[`ĂяoDCPUO[`Ăяo
 *  ́CꎞICPUbND
 *  ̊֐́CfBXpb`⊄݃nh^CPUOnh̏o
 *  Ăяo邱Ƃz肵Ă邪C̏^[Qbg
 *  ŋLqĂ悢D̏ꍇɂ́COMIT_CALLTEX }N`
 *  ΂悢D
 */
extern void	calltex(void);

#endif /* _TASK_H_ */
