/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *  VAI/OfoCXiSIOjhCoiXstprmy16pj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO   INHNO_UART

/*
 *  VAI/O|[gǗubN̒`
 */
typedef struct sio_port_control_block {
    const UH uhMagic ;
    const UH uhBase ;
    const UH uhExcpMask ;
    VP_INT vpiExinf ;
    B bNotExist ;
    B bOpened ;
    B bTxIe ;
    B bRxIe ;
    B bLastIsCr ;
} SIOPCB;

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND    1u      /* M\R[obN */
#define SIO_ERDY_RCV    2u      /* MʒmR[obN */

/*
 *  SIOhCȍ[`
 */
extern void sio_initialize(void) throw() ;

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB *sio_opn_por(ID siopid, VP_INT exinf) throw() ;

/*
 *  VAI/O|[g̃N[Y
 */
extern void sio_cls_por(SIOPCB *siopcb) throw() ;

/*
 *  SIO̊݃nh
 */
extern void sio_handler(void) throw() ;

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL sio_snd_chr(SIOPCB *siopcb, char c) throw() ;

/*
 *  VAI/O|[g̕M
 */
extern INT sio_rcv_chr(SIOPCB *siopcb) throw() ;

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn) throw() ;

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn) throw() ;

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void sio_ierdy_snd(VP_INT exinf) throw() ;

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void sio_ierdy_rcv(VP_INT exinf) throw() ;

/*
 *  VAI/O|[gւ̔񓯊o
 */
extern void sio_asnd_chr( INT c ) throw() ;

/*
 *  VAI/O|[g̔񓯊
 */
extern INT sio_arcv_chr( void ) throw() ;

#endif /* _HW_SERIAL_H_ */
