/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *  vZbTɈˑ`iXstormy16pj
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  vZbT
 */
#define XSTORMY16

/*
 *  ݁^CPUOnhԍ̌^
 */
#ifndef _MACRO_ONLY
typedef UINT INHNO;         /* ݃nhԍ */
typedef UINT EXCNO;         /* CPUOnhԍ */
#endif /* _MACRO_ONLY */

/*
 *  vZbT̃GfBA
 */
#define SIL_ENDIAN SIL_ENDIAN_LITTLE

/*
 *  ݃nhԍ
 */
#define TNUM_INTERRUPT 17   /* 荞ݗv */
#define INHNO_WATCHDOG 0    /* b`hbO^C}[荞݃nhԍ */
#define INHNO_BASETIMER 1   /* x[X^C}[荞݃nhԍ */
#define INHNO_TIMER0 2      /* ^C}[0荞݃nhԍ */
#define INHNO_TIMER1 3      /* ^C}[1荞݃nhԍ */
#define INHNO_UART 16       /* UART荞݃nhԍ */

/*
 *  CPUOnhԍ
 */
#define TNUM_EXCEPTION 4    /* Ov */
#define EXCNO_UDINST 0      /* `ߗOnhԍ */
#define EXCNO_WORDODD 1     /* Ԓnւ̃[hANZXOnhԍ */
#define EXCNO_OUTRANGE 2    /* ͈͊OANZXOnhԍ */
#define EXCNO_UNKNOWN 3     /* sCPUOnhԍ */

#ifndef _MACRO_ONLY

/*
 *  ^CeBbN̒`
 */
extern UINT _kernel_tic_nume ;          /* ^CeBbN̎̕q */
#define TIC_NUME    _kernel_tic_nume    /*     (globalϐƂĒ`) */
#define TIC_DENO    1u                  /* ^CeBbN̎̕ */

/*
 *  fobOpu[N|Cg
 */
#define __BREAKPOINT() { __asm__( "nop" ); __asm__( ".hword 0x0007" ); }

/*
 *  stdiop჌xo͊֐
 */
extern int _write ( int fd, char *buf, int nbytes ) ;
extern int _read ( int fd, char *buf, int nbytes ) ;

#endif /* _MACRO_ONLY */
#endif /* _CPU_DEFS_H_ */
