/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: primary_thread.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#include <vwindows.h>
#include <hal_msg.h>
#include <hw_timer.h>

#include <objbase.h>
#include <shellapi.h>
#include <resource.h>

#include "jsp_kernel.h"
#include "task.h"
#include <eventlog.h>
#include <cpu_rename.h>

    /* Iɔjs֐̃L[ */
struct tagDestructionProcedureQueue
{
	struct tagDestructionProcedureQueue * Next;
	void (*DestructionProcedure)(void *);
	void * Parameter;
};

 /*
  *   vg^Cv錾
  */
extern void kernel_start();
extern void kernel_exit();

 /*
  *   ϐ
  */
HINSTANCE ProcessInstance;
HANDLE    PrimaryThreadHandle;
HWND      PrimaryDialogHandle;
HANDLE    CurrentRunningThreadHandle;
BOOL      ShutdownPostponementRequest;

static HANDLE WorkerThreadHandle = NULL;
static struct tagDestructionProcedureQueue * DestructionProcedureQueue;


 /*
  *  ݎs̃Xbhw肳ꂽ^XNł邩ǂ̃`FbN
  */
Inline 
int isTaskThreadRunning(TCB * tcb)
{   return (tcb != 0) && (tcb->tskctxb.ThreadHandle == CurrentRunningThreadHandle);   }


 /*
  * J[lX^[^
  *   kernel_start͍Ōexit_and_dispatchĂԂ̂ŁAReLXgj
  *   ĐVXbh𐶐B
  */

static DWORD WINAPI
KernelStarter(LPVOID param)
{
    TlsAlloc();
	TlsSetValue(TLS_LOGMASK, (LPVOID)1);
	TlsSetValue(TLS_THREADHANDLE, (LPVOID)CurrentRunningThreadHandle);

    kprintf(("KernelStarter begins performing kernel initialization.\n"));

    kernel_start();

    /* vO͂ɂ͗Ȃ */

	return 0;
}

 /*
  *  ^XNON[` 
  *     Visual C++   -> cpu_config.c Ɉړ܂
  *     mingw/cygwin -> cpu_insn.S   Ɉړ܂
  */
extern void TaskExceptionPerformer(void);

 /*
  * Ւf[`
  *   ԂȂIuWFNgjvVW΍
  */
DWORD WINAPI
ForceShutdownHandler(LPVOID param)
{
	do {
		ShutdownPostponementRequest = FALSE;
		Sleep(5000);
	} while(ShutdownPostponementRequest == TRUE);
	ExitProcess(0);
	return 0;
}

 /*
  * fobOp_CAÕbZ[Wnh
  */
Inline LRESULT CALLBACK
PrimaryDialogCommandHandler(WPARAM wParam, LPARAM lParam)
{
	static BOOL lock_flag;

	switch(wParam)
	{
			/* uNbN̋~v{^ */
		case IDC_CLOCKSUPPLY:
		{
			int state;

			state = SendDlgItemMessage(PrimaryDialogHandle, IDC_CLOCKSUPPLY,BM_GETCHECK,0,0);
			switch(state)
			{
					/* NbN~ -> NbN~߂ and ĂXbh~ */
			case BST_CHECKED:
				if((lock_flag = sense_lock()) != TRUE)
					dis_int(0);
				hw_timer_terminate();
				if(CurrentRunningThreadHandle != NULL)
					SuspendThread(CurrentRunningThreadHandle);
				break;

					/* NbNĊJ -> ŌɎ~߂Xbh̍ĊJ and NbNĊJ */
			case BST_UNCHECKED:
				if(CurrentRunningThreadHandle != NULL)
					ResumeThread(CurrentRunningThreadHandle);
				hw_timer_initialize();
				if(lock_flag != TRUE)
					ena_int(0);
				break;
			}
			break;
		}

	default:
		return FALSE;
	}

	return TRUE;
}

    /*
     *  TOPPERS/JSP Xbhf ^XNfBXpb` 
     */
static void task_dispatcher(int is_taskschedule_required)
{
		/* ܓĂXbh(=+^XN)΁A~߂ */
	if(CurrentRunningThreadHandle != NULL)
	{
		wait_for_thread_suspension_completion(CurrentRunningThreadHandle);

            //Ă̂^XNł΁A݃}XNxۑ
        if(isTaskThreadRunning(runtsk))
			vget_ims(&runtsk->tskctxb.InterruptLevel);
	}

		/* ^XNؑ */

        //fBXpb`Kv
    if(is_taskschedule_required != 0 && enadsp && runtsk != schedtsk)
        runtsk = schedtsk;

        //؊^XN݂ȂÃ^XNN
	if(runtsk != 0l)
	{
		CurrentRunningThreadHandle = runtsk->tskctxb.ThreadHandle;

			/* ^XNO */
		if (runtsk->enatex && runtsk->texptn != 0) 
		{
				/* ^XNON[`ւƍւ */
			CONTEXT context;
			context.ContextFlags = CONTEXT_FULL;
			GetThreadContext(CurrentRunningThreadHandle,&context);
			*(DWORD *)(context.Esp -= 4) = context.Eip;
			context.Eip = (DWORD)TaskExceptionPerformer;
			SetThreadContext(CurrentRunningThreadHandle,&context);
		}else
			chg_ims(runtsk->tskctxb.InterruptLevel);
		
		LOG_DSP_LEAVE(runtsk);
		ResumeThread(runtsk->tskctxb.ThreadHandle);
	}else
	{
			/* ̂ȂȂA荞݂đ҂ */
		CurrentRunningThreadHandle = NULL;
		ena_int(0);
	}
}



	/*
	 * TOPPERS/JSP Xbhf J[lbZ[Wnh
	 */
Inline LRESULT CALLBACK
HALMessageHandler(WPARAM wParam,LPARAM lParam)
{
	switch(wParam)
	{
			/*
			 *u^XNjĂvbZ[W 
			 *  lParam : jΏۃ^XNTCB̃AhX
			 */
	case HALMSG_DESTROY:
        {
            TCB * tcb = (TCB *)lParam;

				    /* tcb == 0 ̂́AKernelStarterexit_and_dispatchƂ̂ */
            if(tcb == 0 || isTaskThreadRunning(tcb)){
                CurrentRunningThreadHandle = NULL;

                    /* ^XN̋Nvoext_tskƁA̎_łłɐVXbh̃nhĂ̂ŏĂ͂Ȃ */

                if(tcb == runtsk)
                    runtsk = 0;
            }
        }

			/*
			 *u^XN؂ւĂvbZ[W
			 */
	case HALMSG_DISPATCH:
        task_dispatcher(1);
        break;

		/*
		 *u荞݂𔭐ĂvbZ[W
		 * lParam : ݔԍ (>0)
		 */
	case HALMSG_INTERRUPT:
        if(lParam == 0 || iniflg == FALSE || ras_int((unsigned int)lParam) == FALSE)
            break;

            /* ݎt : ̂܂܎ */

        /*
         * uɎsׂ荞݂TāAݏJnĂvbZ[W
         */
    case HALMSG_INTERRUPT_FINISH:
        {
			    /* ݎsĂXbh~ */
		    wait_for_thread_suspension_completion(CurrentRunningThreadHandle);

				/* ݃Xbh and fBXpb` */
			if((CurrentRunningThreadHandle = sch_int()) != NULL)
			{
                    //܂œĂ^XN̊݃}XNxޔ
				if(isTaskThreadRunning(runtsk))
					vget_ims(&runtsk->tskctxb.InterruptLevel);

                ResumeThread(CurrentRunningThreadHandle);   //݃XbhN
			}
            else {
                    // ^XNւƖ߂
                task_dispatcher(reqflg);
                reqflg = 0;
            }

			break;
		}

		/*
		 *uǗXbȟłĊ֐sĂvbZ[W
		 *  lParam : p[^i[\̂ւ̃|C^
		 *    p[^\̓
		 *      func  : s֐
		 *      param : p[^ƂēnłA("void *")Ȓl
		 *
		 * ) ^XNŃEBhEƂƁA^XNjŃEBhEĂ܂
		 */
	case HALMSG_EXECUTEPROCEDURE:
		{
			void ** work = (void **)lParam;
			((void (*)(void *))(*work))(*(work+1));
			break;
		}

		/*
		 *uŌ̍Ōɂ̏𓮂Ă(onExitnh)vbZ[W
		 * lParam : ֐sbZ[WƂ ( func,paramւ̃|C^ )
		 */
	case HALMSG_ADDDESTRUCTIONPROCEDURE:
		{
			struct tagDestructionProcedureQueue * scope;
			void ** work = (void **)lParam;

			scope = DestructionProcedureQueue;

			if((DestructionProcedureQueue = GlobalAlloc(GMEM_FIXED, sizeof(struct tagDestructionProcedureQueue))) != NULL)
			{
				DestructionProcedureQueue->DestructionProcedure = *(work);
				DestructionProcedureQueue->Parameter = *(work+1);
				DestructionProcedureQueue->Next = scope;
			}else
				FatalAssertion(TRUE, "GlobalAlloc could not acquire a memory block at " __FILE__);

			break;
		}

		/*
		 *uvO~߂ĂvbZ[W
		 */
	case HALMSG_QUITREQUEST:
		{
			struct tagDestructionProcedureQueue * destqueue;
			void * destarea;

			dis_int(0);		// ݎt̃XbĥŁAʂɋ֎~ȂĂv

//			WorkerThreadHandle = CreateThread(NULL, 0, ForceShutdownHandler, 0, NULL, NULL);

			hw_timer_terminate();

			if(CurrentRunningThreadHandle != NULL)
				wait_for_thread_suspension_completion(CurrentRunningThreadHandle);

			destqueue = DestructionProcedureQueue;
			while(destqueue != NULL)
			{
				(*destqueue->DestructionProcedure)(destqueue->Parameter);
				destarea = destqueue;
				destqueue = destqueue->Next;
				GlobalFree((HGLOBAL)destarea);
			}

			DestroyWindow(PrimaryDialogHandle);
			break;
		}

	default:
		return FALSE;
	}
	return TRUE;
}

/*
 * J[lV~[^̒jƂȂXbh̃bZ[Wnh
 */
LRESULT CALLBACK PrimaryDialogProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
	switch(Msg)
	{
		/* ^XNgCACRŉENbN */
	case HALMSG_MESSAGE+1:
		if(lParam == WM_RBUTTONUP)
			kernel_exit();

		break;

		/* J[lbZ[W */
	case HALMSG_MESSAGE:
		return HALMessageHandler(wParam,lParam);

		/* fobOp_CAÕACẽbZ[W */
	case WM_COMMAND:
		return PrimaryDialogCommandHandler(wParam,lParam);
	
		/* _CAO(bZ[WnhOp) */
	case WM_INITDIALOG:
		{
			DWORD ThreadID;
			NOTIFYICONDATA nid;

			PrimaryDialogHandle = hDlg;	//ꎞI

				/* ^XNgCɃACRo^ */
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.uFlags = NIF_ICON|NIF_TIP|NIF_MESSAGE;
			nid.uID = ID_NOTIFYICON;
			lstrcpy(nid.szTip,"TOPPERS/JSP");
			nid.hWnd = hDlg;
			nid.uCallbackMessage = HALMSG_MESSAGE+1;
			nid.hIcon = LoadIcon(ProcessInstance,MAKEINTRESOURCE(IDI_ERTLICON));

			Shell_NotifyIcon(NIM_ADD,&nid);

				/* J[lʃXbhŋN */
			PrimaryThreadHandle = (HANDLE)hDlg;
			CurrentRunningThreadHandle = CreateThread(NULL,0,KernelStarter,NULL,CREATE_SUSPENDED,&ThreadID);
            ResumeThread(CurrentRunningThreadHandle);

			FatalAssertion(CurrentRunningThreadHandle != NULL, "CreateThread at " __FILE__);

			break;
		}

		/* _CAO悤ƂĂ܂ */
	case WM_CLOSE:
			HALQuitRequest();
			break;

		/* _CAOj܂ */
	case WM_DESTROY:
		{
				/* ^XNgCn */
			NOTIFYICONDATA nid;

			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.uFlags = 0;
			nid.hWnd = hDlg;
			nid.uID = ID_NOTIFYICON;
			Shell_NotifyIcon(NIM_DELETE,&nid);

			PrimaryThreadHandle = NULL;
			PostQuitMessage(0);
			break;
		}

		/* ^C} */
	case WM_TIMER:
			/* 16rbgS1 -> J[l̃^C} */
		if((wParam & 0xffff0000) == 0xffff0000)
		{
				/* 16rbg͊ݔԍ */
			return HALMessageHandler(HALMSG_INTERRUPT,(wParam & 0x0000ffff));
		}
	default:
		return FALSE;
	}
	return TRUE;
}


    /* }`vZbTł肷悤A킴ƒP̃vZbT݂̂ŏ悤ɂ */
void setAffinityMask(void)
{
    DWORD process;
    DWORD system;
    DWORD newaffinitymask;

    if(GetProcessAffinityMask(GetCurrentProcess(), &process, &system) != 0) {
        newaffinitymask = 1;
        while((process & newaffinitymask) == 0)
            newaffinitymask <<= 1;
        SetProcessAffinityMask(GetCurrentProcess(), newaffinitymask);
    }

    kprintf(("setAffinityMask : 0x%08x\n", newaffinitymask));
}

static void initialize(HANDLE hInstance)
{
	ProcessInstance            = hInstance;
	DestructionProcedureQueue  = NULL;
	PrimaryThreadHandle        = NULL;
	CurrentRunningThreadHandle = NULL;

#ifdef KERNEL_DEBUG_MODE
    AllocConsole();
#endif
        /* vZbTt */
    setAffinityMask();

}

static void finalRelease(void)
{
	int i;

    kprintf(("finalRelease()\n"));

	/* jĂȂ^XŇn */
	for(i=0;i<_kernel_tmax_tskid;i++)
	{
		if(_kernel_tcb_table[i].tskctxb.ThreadHandle != NULL)
		{
			if(TerminateThread(_kernel_tcb_table[i].tskctxb.ThreadHandle,0) != 0)
    			CloseHandle(_kernel_tcb_table[i].tskctxb.ThreadHandle);
			_kernel_tcb_table[i].tskctxb.ThreadHandle = NULL;
		}
	}

    /* COMʐMĂXbh~ */
	if(WorkerThreadHandle  != NULL)
	{
		TerminateThread(WorkerThreadHandle ,0);
		CloseHandle(WorkerThreadHandle);
        WorkerThreadHandle = NULL;
	}

#ifdef KERNEL_DEBUG_MODE
    MessageBox(NULL, "The kernel will be shut down.", "TOPPERS/JSP", MB_OK);
    FreeConsole();
#endif

}


/*
 * C֐
 */
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShow)
{
	MSG msg;
	HANDLE hDlg;

    TlsAlloc();

    initialize(hInstance);

	TlsSetValue(TLS_LOGMASK, 0);
    hDlg = CreateDialog(hInstance,"PrimaryDialog",NULL,PrimaryDialogProc);
	if(hDlg != NULL)
	{		
		ShowWindow(PrimaryDialogHandle,SW_HIDE);

		OnDebug(ShowWindow(PrimaryDialogHandle,SW_SHOW));

		while(GetMessage(&msg,NULL,0,0) != 0)
		{
			if(msg.message == WM_QUIT)
				msg.message = 0;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	else
		FatalAssertion(hDlg != NULL, "CreateDialog at " __FILE__ "("  ")");

    finalRelease();

    ExitProcess(msg.wParam);
	return msg.wParam;
}

