/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_defs.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */


/*
 *	vZbTɈˑ`iWindowspj
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define OMIT_SIL_ACCESS

#define WINDOWS

#define INT_NUMINTERRUPTS	7	/* ݖ{ */

#ifndef _MACRO_ONLY

#include <itron.h>
#include <vwindows.h>

typedef	UINT		INHNO;		/* ݃nhԍ */
typedef	UINT		EXCNO;		/* CPUOnhԍ */

/*
 * ݃G~[V֘A
 */

#define INT_STAT_MASK		0x0000ffffu
#define INT_STAT_PENDING	0x00000001u
#define INT_STAT_RUNNING	0x00000002u
#define INT_STAT_ENABLED	0x00000004u

#define INT_MOD_MASK		0xff000000u
#define INT_MOD_LOGMASK		0x01000000u

struct tagInterruptLevel
{
	HANDLE			ThreadHandle;
	DWORD			ThreadID;
	void *			Routine;
	unsigned int	Flags;
};

extern struct tagInterruptLevel InterruptLevel[INT_NUMINTERRUPTS];
extern unsigned int             CurrentInterruptLevel;

/*  O֘A̒` */

#define EXC_MAXITEMS 32

struct tagExceptionLevel
{
	DWORD ExceptionCode;
	void * Routine;
};

extern struct tagExceptionLevel ExceptionLevel[EXC_MAXITEMS];

/*
 * ݃G~[Vp֐
 */

extern BOOL			def_int( unsigned int ims, void * rtn);	/* nh` */
extern BOOL			ini_int( void );				/*  */
extern void			fin_int( void );
extern BOOL			ras_int(unsigned int ims);		/* ݗv */
extern unsigned int sns_int( void );				/* Sense the highest pending request */
extern HANDLE		sch_int( void );				/* 荞݂̃XPW[ */

extern BOOL			set_intlogmask( unsigned int ims, BOOL mask );

 /* Ƌ֎~͈Ɋ֌WȂS&S֎~ƂȂ */
extern ER	ena_int(unsigned int ims);			/*  */
extern ER	dis_int(unsigned int ims);			/* ֎~ */

extern ER	chg_ims(unsigned int ims);			/* ݃x̐ݒ */
extern ER	get_ims(unsigned int *p_ims);		/* ݃x̎擾 */
extern ER	vget_ims(unsigned int *p_ims);		/* ݃x̎擾 */

extern BOOL def_exc(DWORD exc, void * routine);
extern BOOL ini_exc(void);
extern void fin_exc(void);

	/*
	 * VXeNeBJZNV
	 *   CPUbNŁAɓĂԃfBXpb`͔Ȃ
	 */
extern void enter_system_critical_section(BOOL *);
extern void leave_system_critiacl_section(BOOL *);

	/* w肳ꂽ^XNVXeNeBJZNVOŒ~ */
extern ER   wait_for_thread_suspension_completion(HANDLE thread);

    /* V~[V^C} */
extern unsigned int current_timer_clock_unit;

    /* V~[ṼeBbNC
     *   clk : ̃^C}ݖɉV~[V
     *     (clk = 0 : RȒl (TIMER_CLOCK_WINDOWS))
     */
extern ER set_clk(unsigned int clk);

#endif /* _MACRO_ONLY */

/*
 * ^C}[֘A
 */

#include <hw_timer.h>

/*
 *  ^CeBbN̒`
 */
#define	TIC_NUME	current_timer_clock_unit	/* ^CeBbN̎̕q */
#define	TIC_DENO	1						    /* ^CeBbN̎̕ */

#ifndef _MACRO_ONLY

/*
 * g^C}[ (Pentium Timer)
 */

typedef UD SYSUTIM;

Inline ER
vxget_tim(SYSUTIM * pk_sysutim)
{
	QueryPerformanceCounter((LARGE_INTEGER *)pk_sysutim);
	return E_OK;
}

#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
