/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: v850es_kj1.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#ifndef	_V850ES_KJ1_H_
#define	_V850ES_KJ1_H_
/*
 *	vZbTɈˑ`iV850pj
 */
#ifndef _MACRO_ONLY
typedef unsigned char   byte;
typedef unsigned short  word;
typedef unsigned long   dword;
typedef volatile byte   IOREG;
typedef volatile word   HIOREG;
typedef volatile dword  LIOREG;
#endif /* _MACRO_ONLY */

/*
 * RAM
 */
#define	IRAM_TOP	0x03FFB000		/* RAM̐擪AhX */
#define IRAM_SIZE	0x4000			/* RAM̑傫 16Kbyte(uPD70F3318Y) */
/*
 * FlashROM
 */
#define	IROM_TOP	0x0000000		/* FlashROM̐擪AhX */
#define IROM_SIZE	0x40000			/* FlashROM̑傫 256Kbyte(uPD70F3318Y) */

/* 
 * V850ES/KJ1IOWX^`
 */
#define	PDL			0xFFFFF004		/* |[gDLWX^(0x0000) */
#define	PDLL		0xFFFFF004		/* |[gDLWX^L(0x00) */
#define	PDLH		0xFFFFF005		/* |[gDLWX^(0x00) */
#define	PDH			0xFFFFF006		/* |[gDHWX^(0x00) */
#define	PCS			0xFFFFF008		/* |[gCSWX^(0x00) */
#define	PCT			0xFFFFF00A		/* |[gCTWX^(0x00) */
#define	PCM			0xFFFFF00C		/* |[gCMWX^(0x00) */
#define	PCD			0xFFFFF00E		/* |[gCDWX^(0x00) */
#define	PMDL		0xFFFFF024		/* |[gDL[hEWX^(0xFFFF) */
#define	PMDLL		0xFFFFF024		/* |[gDL[hEWX^(0xFF) */
#define	PMDLH		0xFFFFF025		/* |[gDL[hEWX^(0xFF) */
#define	PMDH		0xFFFFF026		/* |[gDH[hEWX^(0xFF) */
#define	PMCS		0xFFFFF028		/* |[gCS[hEWX^(0xFF) */
#define	PMCT		0xFFFFF02A		/* |[gCT[hEWX^(0xFF) */
#define	PMCM		0xFFFFF02C		/* |[gCM[hEWX^(0xFF) */
#define	PMCD		0xFFFFF02E		/* |[gCD[hEWX^(0xFF) */
#define	PMCDL		0xFFFFF044		/* |[gDL[hERg[EWX^(0x0000) */
#define	PMCDLL		0xFFFFF044		/* |[gDL[hERg[EWX^(0x00) */
#define	PMCDLH		0xFFFFF045		/* |[gDL[hERg[EWX^(0x00) */
#define	PMCDH		0xFFFFF046		/* |[gDH[hERg[EWX^(0x00) */
#define	PMCCS		0xFFFFF048		/* |[gCS[hERg[EWX^(0x00) */
#define	PMCCT		0xFFFFF04A		/* |[gCT[hERg[EWX^(0x00) */
#define	PMCCM		0xFFFFF04C		/* |[gCM[hERg[EWX^(0x00) */
#define	BSC			0xFFFFF066		/* oXETCYERtBM[VEWX^(0x5555) */
#define	VSWC		0xFFFFF06E		/* VXeEEGCgERg[EWX^(0x77) */
#define	IMR0		0xFFFFF100		/* 荞݃}XNWX^(0xFFFF) */
#define	IMR0L		0xFFFFF100		/* 荞݃}XNEWX^0(0xFF) */
#define	IMR0H		0xFFFFF101		/* 荞݃}XNEWX^0(0xFF) */
#define	IMR1		0xFFFFF102		/* 荞݃}XNEWX^(0xFFFF) */
#define	IMR1L		0xFFFFF102		/* 荞݃}XNEWX^1(0xFF) */
#define	IMR1H		0xFFFFF103		/* 荞݃}XNEWX^1(0xFF) */
#define	IMR2		0xFFFFF104		/* 荞݃}XNEWX^(0xFFFF) */
#define	IMR2L		0xFFFFF104		/* 荞݃}XNEWX^2(0xFF) */
#define	IMR2H		0xFFFFF105		/* 荞݃}XNEWX^2(0xFF) */
#define	IMR3		0xFFFFF106		/* 荞݃}XNEWX^(0xFFFF) */
#define	IMR3L		0xFFFFF106		/* 荞݃}XNEWX^3(0xFF) */
#define	WDT1IC		0xFFFFF110		/* 荞ݐ䃌WX^(0x47) */
#define	PIC0		0xFFFFF112		/* 荞ݐ䃌WX^(0x47) */
#define	PIC1		0xFFFFF114		/* 荞ݐ䃌WX^(0x47) */
#define	PIC2		0xFFFFF116		/* 荞ݐ䃌WX^(0x47) */
#define	PIC3		0xFFFFF118		/* 荞ݐ䃌WX^(0x47) */
#define	PIC4		0xFFFFF11A		/* 荞ݐ䃌WX^(0x47) */
#define	PIC5		0xFFFFF11C		/* 荞ݐ䃌WX^(0x47) */
#define	PIC6		0xFFFFF11E		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC00		0xFFFFF120		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC01		0xFFFFF122		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC10		0xFFFFF124		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC11		0xFFFFF126		/* 荞ݐ䃌WX^(0x47) */
#define	TM5IC0		0xFFFFF128		/* 荞ݐ䃌WX^(0x47) */
#define	TM5IC1		0xFFFFF12A		/* 荞ݐ䃌WX^(0x47) */
#define	CSI0IC0		0xFFFFF12C		/* 荞ݐ䃌WX^(0x47) */
#define	CSI0IC1		0xFFFFF12E		/* 荞ݐ䃌WX^(0x47) */
#define	SREIC0		0xFFFFF130		/* 荞ݐ䃌WX^(0x47) */
#define	SRIC0		0xFFFFF132		/* 荞ݐ䃌WX^(0x47) */
#define	STIC0		0xFFFFF134		/* 荞ݐ䃌WX^(0x47) */
#define	SREIC1		0xFFFFF136		/* 荞ݐ䃌WX^(0x47) */
#define	SRIC1		0xFFFFF138		/* 荞ݐ䃌WX^(0x47) */
#define	STIC1		0xFFFFF13A		/* 荞ݐ䃌WX^(0x47) */
#define	TMHIC0		0xFFFFF13C		/* 荞ݐ䃌WX^(0x47) */
#define	TMHIC1		0xFFFFF13E		/* 荞ݐ䃌WX^(0x47) */
#define	CSIAIC0		0xFFFFF140		/* 荞ݐ䃌WX^(0x47) */
#define	IICIC0		0xFFFFF142		/* 荞ݐ䃌WX^(0x47) */
#define	ADIC		0xFFFFF144		/* 荞ݐ䃌WX^(0x47) */
#define	KRIC		0xFFFFF146		/* 荞ݐ䃌WX^(0x47) */
#define	WTIIC		0xFFFFF148		/* 荞ݐ䃌WX^(0x47) */
#define	WTIC		0xFFFFF14A		/* 荞ݐ䃌WX^(0x47) */
#define	BRGIC		0xFFFFF14C		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC20		0xFFFFF14E		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC21		0xFFFFF150		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC30		0xFFFFF152		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC31		0xFFFFF154		/* 荞ݐ䃌WX^(0x47) */
#define	CSIAIC1		0xFFFFF156		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC40		0xFFFFF158		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC41		0xFFFFF15A		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC50		0xFFFFF15C		/* 荞ݐ䃌WX^(0x47) */
#define	TM0IC51		0xFFFFF15E		/* 荞ݐ䃌WX^(0x47) */
#define	CSI0IC2		0xFFFFF160		/* 荞ݐ䃌WX^(0x47) */
#define	SREIC2		0xFFFFF162		/* 荞ݐ䃌WX^(0x47) */
#define	SRIC2		0xFFFFF164		/* 荞ݐ䃌WX^(0x47) */
#define	STIC2		0xFFFFF166		/* 荞ݐ䃌WX^(0x47) */
#define	IICIC1		0xFFFFF168		/* 荞ݐ䃌WX^(0x47) */
#define	TP0OVIC		0xFFFFF174		/* 荞ݐ䃌WX^(0x47) */
#define	TP0CCIC0	0xFFFFF176		/* 荞ݐ䃌WX^(0x47) */
#define	TP0CCIC1	0xFFFFF178		/* 荞ݐ䃌WX^(0x47) */
#define	ISPR		0xFFFFF1FA		/* CT[rXEvCIeBEWX^(0x00) */
#define	PRCMD		0xFFFFF1FC		/* R}hEWX^(s) */
#define	PSC			0xFFFFF1FE		/* p[EZ[uERg[EWX^(0x00) */
#define	ADM			0xFFFFF200		/* A/DRo[^E[hEWX^(0x00) */
#define	ADS			0xFFFFF201		/* AiO̓`lw背WX^(0x00) */
#define	PFM			0xFFFFF202		/* p[EtFCr[hEWX^(0x00) */
#define	PFT			0xFFFFF203		/* p[EtFCrlWX^(0x00) */
#define	ADCR		0xFFFFF204		/* A/DϊʃWX^(s) */
#define	ADCRH		0xFFFFF205		/* A/DϊʃWX^(s) */
#define	DACS0		0xFFFFF280		/* D/Aϊlݒ背WX^(0x00) */
#define	DACS1		0xFFFFF282		/* D/Aϊlݒ背WX^(0x00) */
#define	DAM			0xFFFFF284		/* D/ARo[^E[hEWX^(0x00) */
#define	KRM			0xFFFFF300		/* L[E^[E[hEWX^(0x00) */
#define	P0			0xFFFFF400		/* |[g0WX^(0x00) */
#define	P1			0xFFFFF402		/* |[g1WX^(0x00) */
#define	P3			0xFFFFF406		/* |[g3WX^(0x0000) */
#define	P3L			0xFFFFF406		/* |[g3WX^(0x00) */
#define	P3H			0xFFFFF407		/* |[g3WX^(0x00) */
#define	P4			0xFFFFF408		/* |[g4WX^(0x00) */
#define	P5			0xFFFFF40A		/* |[g5WX^(0x00) */
#define	P6			0xFFFFF40C		/* |[g6WX^(0x0000) */
#define	P6L			0xFFFFF40C		/* |[g6WX^(0x00) */
#define	P6H			0xFFFFF40D		/* |[g6WX^(0x00) */
#define	P7			0xFFFFF40E		/* |[g7WX^(s) */
#define	P7L			0xFFFFF40E		/* |[g7WX^(s) */
#define	P7H			0xFFFFF40F		/* |[g7WX^(s) */
#define	P8			0xFFFFF410		/* |[g8WX^(0x00) */
#define	P9			0xFFFFF412		/* |[g9WX^(0x0000) */
#define	P9L			0xFFFFF412		/* |[g9WX^(0x00) */
#define	P9H			0xFFFFF413		/* |[g9WX^(0x00) */
#define	PM0			0xFFFFF420		/* |[g0[hEWX^(0xFF) */
#define	PM1			0xFFFFF422		/* |[g1[hEWX^(0xFF) */
#define	PM3			0xFFFFF426		/* |[g3[hEWX^(0xFFFF) */
#define	PM3L		0xFFFFF426		/* |[g3[hEWX^(0xFF) */
#define	PM3H		0xFFFFF427		/* |[g3[hEWX^(0xFF) */
#define	PM4			0xFFFFF428		/* |[g4[hEWX^(0xFF) */
#define	PM5			0xFFFFF42A		/* |[g5[hEWX^(0xFF) */
#define	PM6			0xFFFFF42C		/* |[g6[hEWX^(0xFFFF) */
#define	PM6L		0xFFFFF42C		/* |[g6[hEWX^(0xFF) */
#define	PM6H		0xFFFFF42D		/* |[g6[hEWX^(0xFF) */
#define	PM8			0xFFFFF430		/* |[g8[hEWX^(0xFF) */
#define	PM9			0xFFFFF432		/* |[g9[hEWX^(0xFFFF) */
#define	PM9L		0xFFFFF432		/* |[g9[hEWX^(0xFF) */
#define	PM9H		0xFFFFF433		/* |[g9[hEWX^(0xFF) */
#define	PMC0		0xFFFFF440		/* |[g0[hERg[EWX^(0x00) */
#define	PMC3		0xFFFFF446		/* |[g3[hERg[EWX^(0x0000) */
#define	PMC3L		0xFFFFF446		/* |[g3[hERg[EWX^(0x00) */
#define	PMC3H		0xFFFFF447		/* |[g3[hERg[EWX^(0x00) */
#define	PMC4		0xFFFFF448		/* |[g4[hERg[EWX^(0x00) */
#define	PMC5		0xFFFFF44A		/* |[g5[hERg[EWX^(0x00) */
#define	PMC6		0xFFFFF44C		/* |[g6[hERg[EWX^(0x0000) */
#define	PMC6L		0xFFFFF44C		/* |[g6[hERg[EWX^(0x00) */
#define	PMC6H		0xFFFFF44D		/* |[g6[hERg[EWX^(0x00) */
#define	PMC8		0xFFFFF450		/* |[g8[hERg[EWX^(0x00) */
#define	PMC9		0xFFFFF452		/* |[g9[hERg[EWX^(0x0000) */
#define	PMC9L		0xFFFFF452		/* |[g9[hERg[EWX^(0x00) */
#define	PMC9H		0xFFFFF453		/* |[g9[hERg[EWX^(0x00) */
#define	PFC3		0xFFFFF466		/* |[g3t@NVERg[EWX^(0x00) */
#define	PFC5		0xFFFFF46A		/* |[g5t@NVERg[EWX^(0x00) */
#define	PFC6H		0xFFFFF46D		/* |[g6t@NVERg[EWX^(0x00) */
#define	PFC8		0xFFFFF470		/* |[g8t@NVERg[EWX^(0x00) */
#define	PFC9		0xFFFFF472		/* |[g9t@NVERg[EWX^(0x0000) */
#define	PFC9L		0xFFFFF472		/* |[g9t@NVERg[EWX^(0x00) */
#define	PFC9H		0xFFFFF473		/* |[g9t@NVERg[EWX^(0x00) */
#define	DWC0		0xFFFFF484		/* f[^EEGCg䃌WX^(0x7777) */
#define	AWC			0xFFFFF488		/* AhXEEGCg䃌WX^(0xFFFF) */
#define	BCC			0xFFFFF48A		/* oXETCN䃌WX^(0xAAAA) */
#define	TMHMD0		0xFFFFF580		/* 8rbgE^C}H[hEWX^(0x00) */
#define	TMCYC0		0xFFFFF581		/* 8rbgE^C}HLAERg[EWX^(0x00) */
#define	CMP00		0xFFFFF582		/* 8rbgE^C}HRyAEWX^0(0x00) */
#define	CMP01		0xFFFFF583		/* 8rbgE^C}HRyAEWX^0(0x00) */
#define	TMHMD1		0xFFFFF590		/* 8rbgE^C}H[hEWX^(0x00) */
#define	TMCYC1		0xFFFFF591		/* 8rbgE^C}HLAERg[EWX^(0x00) */
#define	CMP10		0xFFFFF592		/* 8rbgE^C}HRyAEWX^1(0x00) */
#define	CMP11		0xFFFFF593		/* 8rbgE^C}HRyAEWX^1(0x00) */
#define	TP0CTL0		0xFFFFF5A0		/* TMP0䃌WX^(0x00) */
#define	TP0CTL1		0xFFFFF5A1		/* TMP0䃌WX^(0x00) */
#define	TP0IOC0		0xFFFFF5A2		/* TMP0I/O䃌WX^(0x00) */
#define	TP0IOC1		0xFFFFF5A3		/* TMP0I/O䃌WX^(0x00) */
#define	TP0IOC2		0xFFFFF5A4		/* TMP0I/O䃌WX^(0x00) */
#define	TP0OPT0		0xFFFFF5A5		/* TMP0IvVEWX^(0x00) */
#define	TP0CCR0		0xFFFFF5A6		/* TMP0Lv`^RyAEWX^(0x0000) */
#define	TP0CCR1		0xFFFFF5A8		/* TMP0Lv`^RyAEWX^(0x0000) */
#define	TP0CNT		0xFFFFF5AA		/* TMP0JE^E[hEobt@EWX^(0x0000) */
#define	TM5			0xFFFFF5C0		/* 16rbgE^C}EJE^(0x0000) */
#define	TM50		0xFFFFF5C0		/* 8rbgE^C}EJE^5(0x00) */
#define	TM51		0xFFFFF5C1		/* 8rbgE^C}EJE^5(0x00) */
#define	CR5			0xFFFFF5C2		/* 16rbgE^C}ERyAEWX^(0x0000) */
#define	CR50		0xFFFFF5C2		/* 8rbgE^C}ERyAEWX^5(0x00) */
#define	CR51		0xFFFFF5C3		/* 8rbgE^C}ERyAEWX^5(0x00) */
#define	TCL5		0xFFFFF5C4		/* ^C}ENbNIWX^(0x0000) */
#define	TCL50		0xFFFFF5C4		/* ^C}ENbNIWX^5(0x00) */
#define	TCL51		0xFFFFF5C5		/* ^C}ENbNIWX^5(0x00) */
#define	TMC5		0xFFFFF5C6		/* 16rbgE^C}E[hERg[EWX^(0x0000) */
#define	TMC50		0xFFFFF5C6		/* 8rbgE^C}E[hERg[EWX^5(0x00) */
#define	TMC51		0xFFFFF5C7		/* 8rbgE^C}E[hERg[EWX^5(0x00) */
#define	TM00		0xFFFFF600		/* 16rbgE^C}EJE^0(0x0000) */
#define	CR000		0xFFFFF602		/* 16rbgE^C}ELv`^RyAEWX^00(0x0000) */
#define	CR001		0xFFFFF604		/* 16rbgE^C}ELv`^RyAEWX^00(0x0000) */
#define	TMC00		0xFFFFF606		/* 16rbgE^C}E[hERg[EWX^0(0x00) */
#define	PRM00		0xFFFFF607		/* vXP[E[hEWX^0(0x00) */
#define	CRC00		0xFFFFF608		/* Lv`^RyAERg[EWX^0(0x00) */
#define	TOC00		0xFFFFF609		/* 16rbgE^C}o̓Rg[EWX^0(0x00) */
#define	TM01		0xFFFFF610		/* 16rbgE^C}EJE^0(0x0000) */
#define	CR010		0xFFFFF612		/* 16rbgE^C}ELv`^RyAEWX^01(0x0000) */
#define	CR011		0xFFFFF614		/* 16rbgE^C}ELv`^RyAEWX^01(0x0000) */
#define	TMC01		0xFFFFF616		/* 16rbgE^C}E[hERg[EWX^0(0x00) */
#define	PRM01		0xFFFFF617		/* vXP[E[hEWX^0(0x00) */
#define	CRC01		0xFFFFF618		/* Lv`^RyAERg[EWX^0(0x00) */
#define	TOC01		0xFFFFF619		/* 16rbgE^C}o̓Rg[EWX^0(0x00) */
#define	TM02		0xFFFFF620		/* 16rbgE^C}EJE^0(0x0000) */
#define	CR020		0xFFFFF622		/* 16rbgE^C}ELv`^RyAEWX^02(0x0000) */
#define	CR021		0xFFFFF624		/* 16rbgE^C}ELv`^RyAEWX^02(0x0000) */
#define	TMC02		0xFFFFF626		/* 16rbgE^C}E[hERg[EWX^0(0x00) */
#define	PRM02		0xFFFFF627		/* vXP[E[hEWX^0(0x00) */
#define	CRC02		0xFFFFF628		/* Lv`^RyAERg[EWX^0(0x00) */
#define	TOC02		0xFFFFF629		/* 16rbgE^C}o̓Rg[EWX^0(0x00) */
#define	TM03		0xFFFFF630		/* 16rbgE^C}EJE^0(0x0000) */
#define	CR030		0xFFFFF632		/* 16rbgE^C}ELv`^RyAEWX^03(0x0000) */
#define	CR031		0xFFFFF634		/* 16rbgE^C}ELv`^RyAEWX^03(0x0000) */
#define	TMC03		0xFFFFF636		/* 16rbgE^C}E[hERg[EWX^0(0x00) */
#define	PRM03		0xFFFFF637		/* vXP[E[hEWX^0(0x00) */
#define	CRC03		0xFFFFF638		/* Lv`^RyAERg[EWX^0(0x00) */
#define	TOC03		0xFFFFF639		/* 16rbgE^C}o̓Rg[EWX^0(0x00) */
#define	TM04		0xFFFFF640		/* 16rbgE^C}EJE^0(0x0000) */
#define	CR040		0xFFFFF642		/* 16rbgE^C}ELv`^RyAEWX^04(0x0000) */
#define	CR041		0xFFFFF644		/* 16rbgE^C}ELv`^RyAEWX^04(0x0000) */
#define	TMC04		0xFFFFF646		/* 16rbgE^C}E[hERg[EWX^0(0x00) */
#define	PRM04		0xFFFFF647		/* vXP[E[hEWX^0(0x00) */
#define	CRC04		0xFFFFF648		/* Lv`^RyAERg[EWX^0(0x00) */
#define	TOC04		0xFFFFF649		/* 16rbgE^C}o̓Rg[EWX^0(0x00) */
#define	TM05		0xFFFFF650		/* 16rbgE^C}EJE^0(0x0000) */
#define	CR050		0xFFFFF652		/* 16rbgE^C}ELv`^RyAEWX^05(0x0000) */
#define	CR051		0xFFFFF654		/* 16rbgE^C}ELv`^RyAEWX^05(0x0000) */
#define	TMC05		0xFFFFF656		/* 16rbgE^C}E[hERg[EWX^0(0x00) */
#define	PRM05		0xFFFFF657		/* vXP[E[hEWX^0(0x00) */
#define	CRC05		0xFFFFF658		/* Lv`^RyAERg[EWX^0(0x00) */
#define	TOC05		0xFFFFF659		/* 16rbgE^C}o̓Rg[EWX^0(0x00) */
#define	WTM			0xFFFFF680		/* v^C}샂[hEWX^(0x00) */
#define	OSTS		0xFFFFF6C0		/* U莞ԑIWX^(0x01) */
#define	WDCS		0xFFFFF6C1		/* EHb`hbOE^C}ENbNIWX^(0x00) */
#define	WDTM1		0xFFFFF6C2		/* EHb`hbOE^C}E[hEWX^(0x00) */
#define	WDTM2		0xFFFFF6D0		/* EHb`hbOE^C}E[hEWX^(0x67) */
#define	WDTE		0xFFFFF6D1		/* EHb`hbOE^C}ECl[uEWX^(0x9A) */
#define	RTBL0		0xFFFFF6E0		/* A^Co̓obt@EWX^L(0x00) */
#define	RTBH0		0xFFFFF6E2		/* A^Co̓obt@EWX^H(0x00) */
#define	RTPM0		0xFFFFF6E4		/* A^Co̓|[gE[hEWX^(0x00) */
#define	RTPC0		0xFFFFF6E5		/* A^Co̓|[gERg[EWX^(0x00) */
#define	RTBL1		0xFFFFF6F0		/* A^Co̓obt@EWX^L(0x00) */
#define	RTBH1		0xFFFFF6F2		/* A^Co̓obt@EWX^H(0x00) */
#define	RTPM1		0xFFFFF6F4		/* A^Co̓|[gE[hEWX^(0x00) */
#define	RTPC1		0xFFFFF6F5		/* A^Co̓|[gERg[EWX^(0x00) */
#define	PFCE3		0xFFFFF706		/* |[g3t@NVERg[gWX^(0x00) */
#define	SYS			0xFFFFF802		/* VXeEXe[^XEWX^(0x00) */
#define	PLLCTL		0xFFFFF806		/* PLLRg[EWX^(0x01) */
#define	PSMR		0xFFFFF820		/* p[EZ[uE[hEWX^(0x00) */
#define	PCC			0xFFFFF828		/* vZbTENbNERg[EWX^(0x03) */
#define	CORAD0		0xFFFFF840		/* RNVEAhXEWX^(0x00000000) */
#define	CORAD0L		0xFFFFF840		/* RNVEAhXEWX^0(0x0000) */
#define	CORAD0H		0xFFFFF842		/* RNVEAhXEWX^0(0x0000) */
#define	CORAD1		0xFFFFF844		/* RNVEAhXEWX^(0x00000000) */
#define	CORAD1L		0xFFFFF844		/* RNVEAhXEWX^1(0x0000) */
#define	CORAD1H		0xFFFFF846		/* RNVEAhXEWX^1(0x0000) */
#define	CORAD2		0xFFFFF848		/* RNVEAhXEWX^(0x00000000) */
#define	CORAD2L		0xFFFFF848		/* RNVEAhXEWX^2(0x0000) */
#define	CORAD2H		0xFFFFF84A		/* RNVEAhXEWX^2(0x0000) */
#define	CORAD3		0xFFFFF84C		/* RNVEAhXEWX^(0x00000000) */
#define	CORAD3L		0xFFFFF84C		/* RNVEAhXEWX^3(0x0000) */
#define	CORAD3H		0xFFFFF84E		/* RNVEAhXEWX^3(0x0000) */
#define	CORCN		0xFFFFF880		/* RNVERg[EWX^(0x00) */
#define	PRSM		0xFFFFF8B0		/* C^[oE^C}BRG[hEWX^(0x00) */
#define	PRSCM		0xFFFFF8B1		/* C^[oE^C}BRGRyAEWX^(0x00) */
#define	OCDM		0xFFFFF9FC		/* I`bvEfBoOE[hEWX^(0x01) */
#define	ASIM0		0xFFFFFA00		/* AVNiXEVAEC^tF[XE[hEWX^(0x01) */
#define	RXB0		0xFFFFFA02		/* Mobt@EWX^(0xFF) */
#define	ASIS0		0xFFFFFA03		/* AVNiXEVAEC^tF[XEXe[^XEWX^(0x00) */
#define	TXB0		0xFFFFFA04		/* Mobt@EWX^(0xFF) */
#define	ASIF0		0xFFFFFA05		/* AVNiXEVAEC^tF[XMXe[^XEWX^(0x00) */
#define	CKSR0		0xFFFFFA06		/* NbNIWX^(0x00) */
#define	BRGC0		0xFFFFFA07		/* {[E[gEWFl[^ERg[EWX^(0xFF) */
#define	ASIM1		0xFFFFFA10		/* AVNiXEVAEC^tF[XE[hEWX^(0x01) */
#define	RXB1		0xFFFFFA12		/* Mobt@EWX^(0xFF) */
#define	ASIS1		0xFFFFFA13		/* AVNiXEVAEC^tF[XEXe[^XEWX^(0x00) */
#define	TXB1		0xFFFFFA14		/* Mobt@EWX^(0xFF) */
#define	ASIF1		0xFFFFFA15		/* AVNiXEVAEC^tF[XMXe[^XEWX^(0x00) */
#define	CKSR1		0xFFFFFA16		/* NbNIWX^(0x00) */
#define	BRGC1		0xFFFFFA17		/* {[E[gEWFl[^ERg[EWX^(0xFF) */
#define	ASIM2		0xFFFFFA20		/* AVNiXEVAEC^tF[XE[hEWX^(0x01) */
#define	RXB2		0xFFFFFA22		/* Mobt@EWX^(0xFF) */
#define	ASIS2		0xFFFFFA23		/* AVNiXEVAEC^tF[XEXe[^XEWX^(0x00) */
#define	TXB2		0xFFFFFA24		/* Mobt@EWX^(0xFF) */
#define	ASIF2		0xFFFFFA25		/* AVNiXEVAEC^tF[XMXe[^XEWX^(0x00) */
#define	CKSR2		0xFFFFFA26		/* NbNIWX^(0x00) */
#define	BRGC2		0xFFFFFA27		/* {[E[gEWFl[^ERg[EWX^(0xFF) */
#define	P0NFC		0xFFFFFB00		/* TIP00mCY䃌WX^(0x00) */
#define	P1NFC		0xFFFFFB04		/* TIP01mCY䃌WX^(0x00) */
#define	INTF0		0xFFFFFC00		/* O荞ݗGbWw背WX^(0x00) */
#define	INTF9H		0xFFFFFC13		/* O荞ݗGbWw背WX^9(0x00) */
#define	INTR0		0xFFFFFC20		/* O荞ݗオGbWw背WX^(0x00) */
#define	INTR9H		0xFFFFFC33		/* O荞ݗオGbWw背WX^9(0x00) */
#define	PU0			0xFFFFFC40		/* vAbvRIvVEWX^(0x00) */
#define	PU1			0xFFFFFC42		/* vAbvRIvVEWX^(0x00) */
#define	PU3			0xFFFFFC46		/* vAbvRIvVEWX^(0x00) */
#define	PU4			0xFFFFFC48		/* vAbvRIvVEWX^(0x00) */
#define	PU5			0xFFFFFC4A		/* vAbvRIvVEWX^(0x00) */
#define	PU6			0xFFFFFC4C		/* vAbvRIvVEWX^(0x0000) */
#define	PU6L		0xFFFFFC4C		/* vAbvRIvVEWX^6(0x00) */
#define	PU6H		0xFFFFFC4D		/* vAbvRIvVEWX^6(0x00) */
#define	PU8			0xFFFFFC50		/* vAbvRIvVEWX^(0x00) */
#define	PU9			0xFFFFFC52		/* vAbvRIvVEWX^(0x0000) */
#define	PU9L		0xFFFFFC52		/* vAbvRIvVEWX^9(0x00) */
#define	PU9H		0xFFFFFC53		/* vAbvRIvVEWX^9(0x00) */
#define	PF3H		0xFFFFFC67		/* |[g3t@NVEWX^(0x00) */
#define	PF4			0xFFFFFC68		/* |[g4t@NVEWX^(0x00) */
#define	PF5			0xFFFFFC6A		/* |[g5t@NVEWX^(0x00) */
#define	PF6			0xFFFFFC6C		/* |[g6t@NVEWX^(0x0000) */
#define	PF6L		0xFFFFFC6C		/* |[g6t@NVEWX^(0x00) */
#define	PF6H		0xFFFFFC6D		/* |[g6t@NVEWX^(0x00) */
#define	PF8			0xFFFFFC70		/* |[g8t@NVEWX^(0x00) */
#define	PF9H		0xFFFFFC73		/* |[g9t@NVEWX^(0x00) */
#define	CSIM00		0xFFFFFD00		/* NbNVAEC^tF[XE[hEWX^0(0x00) */
#define	CSIC0		0xFFFFFD01		/* NbNVAEC^tF[XENbNIWX^(0x00) */
#define	SIRB0		0xFFFFFD02		/* NbNVAEC^tF[XMobt@EWX^(0x0000) */
#define	SIRB0L		0xFFFFFD02		/* NbNVAEC^tF[XMobt@EWX^0(0x00) */
#define	SOTB0		0xFFFFFD04		/* NbNVAEC^tF[XMobt@EWX^(0x0000) */
#define	SOTB0L		0xFFFFFD04		/* NbNVAEC^tF[XMobt@EWX^0(0x00) */
#define	SIRBE0		0xFFFFFD06		/* NbNVAEC^tF[XE[hpMobt@EWX^(0x0000) */
#define	SIRBE0L		0xFFFFFD06		/* NbNVAEC^tF[XE[hpMobt@EWX^0(0x00) */
#define	SOTBF0		0xFFFFFD08		/* NbNVAEC^tF[XiMobt@EWX^(0x0000) */
#define	SOTBF0L		0xFFFFFD08		/* NbNVAEC^tF[XiMobt@EWX^0(0x00) */
#define	SIO00		0xFFFFFD0A		/* VAI/OVtgEWX^(0x00) */
#define	SIO00L		0xFFFFFD0A		/* VAI/OVtgEWX^0(0x0000) */
#define	CSIM01		0xFFFFFD10		/* NbNVAEC^tF[XE[hEWX^0(0x00) */
#define	CSIC1		0xFFFFFD11		/* NbNVAEC^tF[XENbNIWX^(0x00) */
#define	SIRB1		0xFFFFFD12		/* NbNVAEC^tF[XMobt@EWX^(0x0000) */
#define	SIRB1L		0xFFFFFD12		/* NbNVAEC^tF[XMobt@EWX^1(0x00) */
#define	SOTB1		0xFFFFFD14		/* NbNVAEC^tF[XMobt@EWX^(0x0000) */
#define	SOTB1L		0xFFFFFD14		/* NbNVAEC^tF[XMobt@EWX^1(0x00) */
#define	SIRBE1		0xFFFFFD16		/* NbNVAEC^tF[XE[hpMobt@EWX^(0x0000) */
#define	SIRBE1L		0xFFFFFD16		/* NbNVAEC^tF[XE[hpMobt@EWX^1(0x00) */
#define	SOTBF1		0xFFFFFD18		/* NbNVAEC^tF[XiMobt@EWX^(0x0000) */
#define	SOTBF1L		0xFFFFFD18		/* NbNVAEC^tF[XiMobt@EWX^1(0x00) */
#define	SIO01		0xFFFFFD1A		/* VAI/OVtgEWX^(0x00) */
#define	SIO01L		0xFFFFFD1A		/* VAI/OVtgEWX^1(0x0000) */
#define	CSIM02		0xFFFFFD20		/* NbNVAEC^tF[XE[hEWX^0(0x00) */
#define	CSIC2		0xFFFFFD21		/* NbNVAEC^tF[XENbNIWX^(0x00) */
#define	SIRB2		0xFFFFFD22		/* NbNVAEC^tF[XMobt@EWX^(0x0000) */
#define	SIRB2L		0xFFFFFD22		/* NbNVAEC^tF[XMobt@EWX^2(0x00) */
#define	SOTB2		0xFFFFFD24		/* NbNVAEC^tF[XMobt@EWX^(0x0000) */
#define	SOTB2L		0xFFFFFD24		/* NbNVAEC^tF[XMobt@EWX^2(0x00) */
#define	SIRBE2		0xFFFFFD26		/* NbNVAEC^tF[XE[hpMobt@EWX^(0x0000) */
#define	SIRBE2L		0xFFFFFD26		/* NbNVAEC^tF[XE[hpMobt@EWX^2(0x00) */
#define	SOTBF2		0xFFFFFD28		/* NbNVAEC^tF[XiMobt@EWX^(0x0000) */
#define	SOTBF2L		0xFFFFFD28		/* NbNVAEC^tF[XiMobt@EWX^2(0x00) */
#define	SIO02		0xFFFFFD2A		/* VAI/OVtgEWX^(0x00) */
#define	SIO02L		0xFFFFFD2A		/* VAI/OVtgEWX^2(0x0000) */
#define	CSIMA0		0xFFFFFD40		/* VA샂[hw背WX^(0x00) */
#define	CSIS0		0xFFFFFD41		/* VAEXe[^XEWX^(0x00) */
#define	CSIT0		0xFFFFFD42		/* VAEgKEWX^(0x00) */
#define	BRGCA0		0xFFFFFD43		/* lIWX^(0x03) */
#define	ADTP0		0xFFFFFD44		/* f[^]AhXE|Cgw背WX^(0x00) */
#define	ADTI0		0xFFFFFD45		/* f[^]Ԋuw背WX^(0x00) */
#define	SIOA0		0xFFFFFD46		/* VAI/OVtgEWX^A(0x00) */
#define	ADTC0		0xFFFFFD47		/* f[^]AhXEJEgEWX^(0x00) */
#define	CSIMA1		0xFFFFFD50		/* VA샂[hw背WX^(0x00) */
#define	CSIS1		0xFFFFFD51		/* VAEXe[^XEWX^(0x00) */
#define	CSIT1		0xFFFFFD52		/* VAEgKEWX^(0x00) */
#define	BRGCA1		0xFFFFFD53		/* lIWX^(0x03) */
#define	ADTP1		0xFFFFFD54		/* f[^]AhXE|Cgw背WX^(0x00) */
#define	ADTI1		0xFFFFFD55		/* f[^]Ԋuw背WX^(0x00) */
#define	SIOA1		0xFFFFFD56		/* VAI/OVtgEWX^A(0x00) */
#define	ADTC1		0xFFFFFD57		/* f[^]AhXEJEgEWX^(0x00) */
#define	IIC0		0xFFFFFD80		/* IICVtgEWX^(0x00) */
#define	IICC0		0xFFFFFD82		/* IICRg[EWX^(0x00) */
#define	SVA0		0xFFFFFD83		/* X[uEAhXEWX^(0x00) */
#define	IICCL0		0xFFFFFD84		/* IICNbNIWX^(0x00) */
#define	IICX0		0xFFFFFD85		/* IIC@\gWX^(0x00) */
#define	IICS0		0xFFFFFD86		/* IICԃWX^(0x00) */
#define	IICF0		0xFFFFFD8A		/* IICtOEWX^(0x00) */
#define	IIC1		0xFFFFFD90		/* IICVtgEWX^(0x00) */
#define	IICC01		0xFFFFFD92		/* IICRg[EWX^(0x00) */
#define	SVA01		0xFFFFFD93		/* X[uEAhXEWX^(0x00) */
#define	IICCL01		0xFFFFFD94		/* IICNbNIWX^(0x00) */
#define	IICX1		0xFFFFFD95		/* IIC@\gWX^(0x00) */
#define	IICS01		0xFFFFFD96		/* IICԃWX^(0x00) */
#define	IICF1		0xFFFFFD9A		/* IICtOEWX^(0x00) */
#define	CSIA0B0		0xFFFFFE00		/* CSIA0obt@RAM0(s) */
#define	CSIA0B0L	0xFFFFFE00		/* CSIA0obt@RAM0L(s) */
#define	CSIA0B0H	0xFFFFFE01		/* CSIA0obt@RAM0H(s) */
#define	CSIA0B1		0xFFFFFE02		/* CSIA0obt@RAM1(s) */
#define	CSIA0B1L	0xFFFFFE02		/* CSIA0obt@RAM1L(s) */
#define	CSIA0B1H	0xFFFFFE03		/* CSIA0obt@RAM1H(s) */
#define	CSIA0B2		0xFFFFFE04		/* CSIA0obt@RAM2(s) */
#define	CSIA0B2L	0xFFFFFE04		/* CSIA0obt@RAM2L(s) */
#define	CSIA0B2H	0xFFFFFE05		/* CSIA0obt@RAM2H(s) */
#define	CSIA0B3		0xFFFFFE06		/* CSIA0obt@RAM3(s) */
#define	CSIA0B3L	0xFFFFFE06		/* CSIA0obt@RAM3L(s) */
#define	CSIA0B3H	0xFFFFFE07		/* CSIA0obt@RAM3H(s) */
#define	CSIA0B4		0xFFFFFE08		/* CSIA0obt@RAM4(s) */
#define	CSIA0B4L	0xFFFFFE08		/* CSIA0obt@RAM4L(s) */
#define	CSIA0B4H	0xFFFFFE09		/* CSIA0obt@RAM4H(s) */
#define	CSIA0B5		0xFFFFFE0A		/* CSIA0obt@RAM5(s) */
#define	CSIA0B5L	0xFFFFFE0A		/* CSIA0obt@RAM5L(s) */
#define	CSIA0B5H	0xFFFFFE0B		/* CSIA0obt@RAM5H(s) */
#define	CSIA0B6		0xFFFFFE0C		/* CSIA0obt@RAM6(s) */
#define	CSIA0B6L	0xFFFFFE0C		/* CSIA0obt@RAM6L(s) */
#define	CSIA0B6H	0xFFFFFE0D		/* CSIA0obt@RAM6H(s) */
#define	CSIA0B7		0xFFFFFE0E		/* CSIA0obt@RAM7(s) */
#define	CSIA0B7L	0xFFFFFE0E		/* CSIA0obt@RAM7L(s) */
#define	CSIA0B7H	0xFFFFFE0F		/* CSIA0obt@RAM7H(s) */
#define	CSIA0B8		0xFFFFFE10		/* CSIA0obt@RAM8(s) */
#define	CSIA0B8L	0xFFFFFE10		/* CSIA0obt@RAM8L(s) */
#define	CSIA0B8H	0xFFFFFE11		/* CSIA0obt@RAM8H(s) */
#define	CSIA0B9		0xFFFFFE12		/* CSIA0obt@RAM9(s) */
#define	CSIA0B9L	0xFFFFFE12		/* CSIA0obt@RAM9L(s) */
#define	CSIA0B9H	0xFFFFFE13		/* CSIA0obt@RAM9H(s) */
#define	CSIA0BA		0xFFFFFE14		/* CSIA0obt@RAMA(s) */
#define	CSIA0BAL	0xFFFFFE14		/* CSIA0obt@RAMAL(s) */
#define	CSIA0BAH	0xFFFFFE15		/* CSIA0obt@RAMAH(s) */
#define	CSIA0BB		0xFFFFFE16		/* CSIA0obt@RAMB(s) */
#define	CSIA0BBL	0xFFFFFE16		/* CSIA0obt@RAMBL(s) */
#define	CSIA0BBH	0xFFFFFE17		/* CSIA0obt@RAMBH(s) */
#define	CSIA0BC		0xFFFFFE18		/* CSIA0obt@RAMC(s) */
#define	CSIA0BCL	0xFFFFFE18		/* CSIA0obt@RAMCL(s) */
#define	CSIA0BCH	0xFFFFFE19		/* CSIA0obt@RAMCH(s) */
#define	CSIA0BD		0xFFFFFE1A		/* CSIA0obt@RAMD(s) */
#define	CSIA0BDL	0xFFFFFE1A		/* CSIA0obt@RAMDL(s) */
#define	CSIA0BDH	0xFFFFFE1B		/* CSIA0obt@RAMDH(s) */
#define	CSIA0BE		0xFFFFFE1C		/* CSIA0obt@RAME(s) */
#define	CSIA0BEL	0xFFFFFE1C		/* CSIA0obt@RAMEL(s) */
#define	CSIA0BEH	0xFFFFFE1D		/* CSIA0obt@RAMEH(s) */
#define	CSIA0BF		0xFFFFFE1E		/* CSIA0obt@RAMF(s) */
#define	CSIA0BFL	0xFFFFFE1E		/* CSIA0obt@RAMFL(s) */
#define	CSIA0BFH	0xFFFFFE1F		/* CSIA0obt@RAMFH(s) */
#define	CSIA1B0		0xFFFFFE20		/* CSIA1obt@RAM0(s) */
#define	CSIA1B0L	0xFFFFFE20		/* CSIA1obt@RAM0L(s) */
#define	CSIA1B0H	0xFFFFFE21		/* CSIA1obt@RAM0H(s) */
#define	CSIA1B1		0xFFFFFE22		/* CSIA1obt@RAM1(s) */
#define	CSIA1B1L	0xFFFFFE22		/* CSIA1obt@RAM1L(s) */
#define	CSIA1B1H	0xFFFFFE23		/* CSIA1obt@RAM1H(s) */
#define	CSIA1B2		0xFFFFFE24		/* CSIA1obt@RAM2(s) */
#define	CSIA1B2L	0xFFFFFE24		/* CSIA1obt@RAM2L(s) */
#define	CSIA1B2H	0xFFFFFE25		/* CSIA1obt@RAM2H(s) */
#define	CSIA1B3		0xFFFFFE26		/* CSIA1obt@RAM3(s) */
#define	CSIA1B3L	0xFFFFFE26		/* CSIA1obt@RAM3L(s) */
#define	CSIA1B3H	0xFFFFFE27		/* CSIA1obt@RAM3H(s) */
#define	CSIA1B4		0xFFFFFE28		/* CSIA1obt@RAM4(s) */
#define	CSIA1B4L	0xFFFFFE28		/* CSIA1obt@RAM4L(s) */
#define	CSIA1B4H	0xFFFFFE29		/* CSIA1obt@RAM4H(s) */
#define	CSIA1B5		0xFFFFFE2A		/* CSIA1obt@RAM5(s) */
#define	CSIA1B5L	0xFFFFFE2A		/* CSIA1obt@RAM5L(s) */
#define	CSIA1B5H	0xFFFFFE2B		/* CSIA1obt@RAM5H(s) */
#define	CSIA1B6		0xFFFFFE2C		/* CSIA1obt@RAM6(s) */
#define	CSIA1B6L	0xFFFFFE2C		/* CSIA1obt@RAM6L(s) */
#define	CSIA1B6H	0xFFFFFE2D		/* CSIA1obt@RAM6H(s) */
#define	CSIA1B7		0xFFFFFE2E		/* CSIA1obt@RAM7(s) */
#define	CSIA1B7L	0xFFFFFE2E		/* CSIA1obt@RAM7L(s) */
#define	CSIA1B7H	0xFFFFFE2F		/* CSIA1obt@RAM7H(s) */
#define	CSIA1B8		0xFFFFFE30		/* CSIA1obt@RAM8(s) */
#define	CSIA1B8L	0xFFFFFE30		/* CSIA1obt@RAM8L(s) */
#define	CSIA1B8H	0xFFFFFE31		/* CSIA1obt@RAM8H(s) */
#define	CSIA1B9		0xFFFFFE32		/* CSIA1obt@RAM9(s) */
#define	CSIA1B9L	0xFFFFFE32		/* CSIA1obt@RAM9L(s) */
#define	CSIA1B9H	0xFFFFFE33		/* CSIA1obt@RAM9H(s) */
#define	CSIA1BA		0xFFFFFE34		/* CSIA1obt@RAMA(s) */
#define	CSIA1BAL	0xFFFFFE34		/* CSIA1obt@RAMAL(s) */
#define	CSIA1BAH	0xFFFFFE35		/* CSIA1obt@RAMAH(s) */
#define	CSIA1BB		0xFFFFFE36		/* CSIA1obt@RAMB(s) */
#define	CSIA1BBL	0xFFFFFE36		/* CSIA1obt@RAMBL(s) */
#define	CSIA1BBH	0xFFFFFE37		/* CSIA1obt@RAMBH(s) */
#define	CSIA1BC		0xFFFFFE38		/* CSIA1obt@RAMC(s) */
#define	CSIA1BCL	0xFFFFFE38		/* CSIA1obt@RAMCL(s) */
#define	CSIA1BCH	0xFFFFFE39		/* CSIA1obt@RAMCH(s) */
#define	CSIA1BD		0xFFFFFE3A		/* CSIA1obt@RAMD(s) */
#define	CSIA1BDL	0xFFFFFE3A		/* CSIA1obt@RAMDL(s) */
#define	CSIA1BDH	0xFFFFFE3B		/* CSIA1obt@RAMDH(s) */
#define	CSIA1BE		0xFFFFFE3C		/* CSIA1obt@RAME(s) */
#define	CSIA1BEL	0xFFFFFE3C		/* CSIA1obt@RAMEL(s) */
#define	CSIA1BEH	0xFFFFFE3D		/* CSIA1obt@RAMEH(s) */
#define	CSIA1BF		0xFFFFFE3E		/* CSIA1obt@RAMF(s) */
#define	CSIA1BFL	0xFFFFFE3E		/* CSIA1obt@RAMFL(s) */
#define	CSIA1BFH	0xFFFFFE3F		/* CSIA1obt@RAMFH(s) */
#define	EXIMC		0xFFFFFFBE		/* OoXEC^tF[XE[hERg[EWX^(0x00) */

#endif	/* _V850ES_KJ1_H_ */
