/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

/*
 *	vZbTˑW[iTLCS-900L1pj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm T|[g邩ǂ̒`
 */
#define	SUPPORT_CHG_IPM

/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	4	/* priority tB[h̃rbg */

#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	VP	xsp;		/* X^bN|C^ */
	FP	pc;		/* vOJE^ */
} CTXB;

/* 
 *  /CPUOlXgJE^
 */
extern UINT	intcnt;

/*
 *  ݃}XN색Cu
 *
 *  ݃}XNiintmaskj́CIPMiInterrupt Priority Maskj12rbg
 *  ɃVtĝłD
 */

/*
 *  ݂̊݃}XN̓Ǐo
 */
#pragma inline current_intmask
UH
current_intmask()
{
	return(current_sr() & 0x7000);
}

/*
 *  ݃}XN̐ݒ
 */
#pragma inline set_intmask
void
set_intmask(UH intmask)
{
	set_sr((current_sr() & ~0x7000) | intmask);
}

/*
 *  VXeԎQ
 */

#pragma inline sense_context
BOOL
sense_context()
{
	Asm("	ldc	hl, intnest");
	return __HL;
}

#pragma inline sense_lock
BOOL
sense_lock()
{
	return(current_intmask() == 0x7000);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ctask_intmask  0 ɂȂĂƍl΂悢D
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

#pragma inline t_lock_cpu
void
t_lock_cpu()
{
	disint();
}

#pragma inline t_unlock_cpu
void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽
	 *  ߁C̓r task_intmask 邱Ƃ͂ȂD
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern UH	int_intmask;	/* ^XNReLXgł̊݃}XN */

#pragma inline i_lock_cpu
void
i_lock_cpu()
{
	UH	intmask;

	/*
	 *  ꎞϐ intmask gĂ̂́Ccurrent_intmask() 
	 *  񂾒Ɋ݂CNꂽ݃nh
	 *  int_intmask ύX\邽߂łD
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}

#pragma inline i_unlock_cpu
void
i_unlock_cpu()
{
	set_intmask(int_intmask);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.asmj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.asmj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 *  ݃nho^xN^e[uROMɎ,
 *  ɏ. ̂߂ł͉ȂD
 */

#pragma inline define_inh
void
define_inh(INHNO inhno, FP inthdr)
{
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 *  ݃nho^xN^e[uROMɎ,
 *  ɏ. ̂߂ł͉ȂD
 */
#pragma inline define_exc
void
define_exc(EXCNO excno, FP exchdr)
{
}


/*
 *  ݃nh^CPUOnh̏o
 */

/*
 *  ݃nh̓̐}N
 *
 *  ݔ̃X^bN̐؂ւ\tgEFAŎD̂߁C
 *  ݃nhɂĊ݋֎~sDȂCݔ
 *  ݋֎~s܂ł̊Ԃɑd݂ƁCd݂ł
 *  Ƃ\tgEFAŌmłȂ߁Cŏɔݏ
 *  sȂ܂܃^XNfBXpb`\D̑d݂
 *  m邽߂Ƀn[hEFA INTNEST WX^𗘗pD
 *
 *  TLCS-900 Family C Compiler ł XIZ WX^ȊO͑SăXNb`
 *  WX^łDȂCŎgpXNb`WX^݂̂
 *  ŕێCc͊݋ʏŕێD
 *
 *  Cꍇ́CCPUOnh}Nl
 *  C邱ƁD
 */
#define	INTHDR_ENTRY(inthdr) \
extern void _kernel_interrupt(void); \
extern void inthdr##(void); \
void inthdr##_entry(void) \
{ \
Asm("	push	xwa	");	/* gpXNb`WX^ۑ */ \
Asm("	push	sr");	/* ݔIFF擾	*/ \
Asm("	pop		wa"); \
Asm("	ei		7");	/* ݋֎~	*/ \
Asm("	push	xhl	");	/* gpXNb`WX^ۑ */ \
Asm("	ld		xhl, _" #inthdr );	/* [Unh|C^擾	*/ \
Asm("	jp	__kernel_interrupt"	);	/* ݋ʏ	*/ \
}
/*
 *  LCꍇ́CCPUOnh}Nl
 *  C邱ƁD
 */


#define	INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPUOnh̏o̐}N
 *
 *  CPUOnh́C^XNReLXgŎsD
 *  CPUOnh́C݃nhƓƂD
 *  ȂCOnḧ^قȂ邽߁C̃}Nʓr
 *  D
 *
 *  Cꍇ́C̊݃nh}Nl
 *  C邱ƁD
 */

#define	EXCHDR_ENTRY(exchdr) \
extern void _kernel_interrupt(void); \
extern void exchdr##(VP p_excinf); \
void exchdr##_entry(void) \
{ \
Asm("	push	xwa	");	/* gpXNb`WX^ۑ */ \
Asm("	push	sr");	/* ݔIFF擾	*/ \
Asm("	pop		wa"); \
Asm("	ei		7");	/* ݋֎~	*/ \
Asm("	push	xhl	");	/* gpXNb`WX^ۑ */ \
Asm("	ld		xhl, _" #exchdr );	/* [Unh|C^擾	*/ \
Asm("	jp	__kernel_interrupt"	);	/* ݋ʏ	*/ \
}
/*
 *  Cꍇ́C̊݃nh}Nl
 *  C邱ƁD
 */

#define	EXC_ENTRY(exchdr)	exchdr##_entry


/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg̎Q
 */
#pragma inline exc_sense_context
BOOL
exc_sense_context(VP p_excinf)
{
	Asm("	ldc	hl, intnest");
	return ( __HL > 1 );
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
#pragma inline exc_sense_lock
BOOL
exc_sense_lock(VP p_excinf)
{
	return ((*((UH *) p_excinf) & 0x7000) == 0x7000);
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
