/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                                  Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: start.S,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */
        
/*
 *  J[lp̃X^[gAbvW[
 */               
#define _MACRO_ONLY
#include <t_config.h>
#include <sys_defs.h>
        
/*
 *   SH3pX^[gAbvW[
 *   J[l̓AvP[VƃNĎgp
 *   Ȃ̂JSPJ[l̂ݎgpB	
 */
	.global	_start
	.align 2
_start:
	/*
	 *  LbV̏
	 */
	mov.l _ccr_addr,r1
	mov.l _ccr_disable,r2
	mov.l r2,@r1
	mov.l _ccr_mode,r2
	mov.l r2,@r1

	/*
	 *  SRB
	 *  MD=1, RB=0, BL=0, I3`I0=e fstub̂
	 */
	mov.l _init_sr,r0
	ldc   r0,sr
	mov   #0x01,r0
	ldc   r0,r7_bank
	/*
	 * ^XNƗ̃X^bNSTACKTOPɏ
	 * STACKTOṔAsys_config.hŒ`
	 */
	mov.l  _stack_k, r15

	/*
	 *  _hardware_init_hook ĂяoB(0łȂꍇ)
	 *
	 *  n[hEFAˑɕKvȏꍇ́C
	 *  hardware_init_hook Ƃ֐pӂ΂悢D
	 *  ̓IɂROM̍ہARAMgp\ɂ邽߂
	 *  oXRg[̏sB
	 *  sys_support.S  _hardware_init_hook `Ă
	 *  D
	 */

start_0:
	mov.l  _hardware_init_hook_k, r0
	tst    r0,r0
	bt     start_1
	jsr    @r0
     or      r0,r0

	
	/*
     * bssZNVNA
	 */
start_1:		
	mov.l	_bss_start_k,r0
	mov.l	_end_k,r1
	cmp/eq  r0,r1
	bt      start_3
	mov	    #0,r2
start_2:
    mov.l	r2,@r0
	add	#4,r0
 	cmp/hi	r0,r1
	bt	start_2

	/*
	 *  dataZNViROMΉjD
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~
	 *  Rs[D
	 */
start_3:
	mov.l   __idata_start_k,r1
	mov.l   __idata_end_k,r2
	cmp/eq  r1,r2
	bt      start_5
	mov.l   __data_start_k,r0
start_4:	
	mov.l   @r1+,r4
	mov.l   r4,@r0
	cmp/hi  r1,r2
	add     #4,r0
	bt      start_4

		
	/*
	 *  _software_init_hook Ăяoi0 łȂꍇjD
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
	 *  悢D
	 */
start_5:	
	mov.l  _software_init_hook_k, r0
	tst    r0,r0
	bt     start_6		
	jsr    @r0
	or     r0,r0

		
start_6:
	/*	
     *  J[lN
	 */
	! call the mainline
	mov.l _kernel_start_k,r0
	jsr	  @r0
     or	   r0,r0


	.align 4
_ccr_addr:	
	.long CCR
_ccr_disable:	
	.long CCR_DISABLE
_ccr_mode:	
	.long CCR_MODE
_init_sr:	
	.long  0x40000000 + MAX_IPM << 4
_stack_k:	
	.long   STACKTOP
_bss_start_k:	
	.long   __bss_start	
_end_k:	
	.long  	_end	
__idata_start_k:	
	.long 	__idata_start
__idata_end_k:	
	.long   __idata_end
__data_start_k:	
	.long  	__data_start	
_kernel_start_k:	
	.long	_kernel_start
_hardware_init_hook_k:	
	.long   _hardware_init_hook
_software_init_hook_k:	
	.long   _software_init_hook	


















