/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *  CPUˑ^C}W[iSH3/4pj
 *  TMU0gp
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

/*
 *  ^C}݃nhINTEVTԍ
 */
#define	INHNO_TIMER	TMU0_INTEVT

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UW	CLOCK;

#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define MAX_CLOCK	((CLOCK) 0xffffffff)

/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define GET_TOLERANCE	100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
        
	/*
	 *  ^C}֘A̐ݒ
	 */
    sil_wrb_mem((VP)TMU_TSTR,
                (sil_reb_mem((VP)TMU_TSTR) & ~TMU_STR0));  /* ^C}~ */
    assert(cyc <= MAX_CLOCK);		     /* ^C}l̃`FbN */

    /* ݒA荞݋ */
    sil_wrh_mem((VP)TMU_TCR0,(0x020 | TCR0_TPSC));
    
    sil_wrw_mem((VP)TMU_TCOR0, cyc); /* timer constantWX^Zbg */
    sil_wrw_mem((VP)TMU_TCNT0, cyc); /* JE^[Zbg */
    /* ^C}0X^[g */
    sil_wrb_mem((VP)TMU_TSTR,
                (sil_reb_mem((VP)TMU_TSTR) | TMU_STR0));

    
    /*
	 *  ݊֘A̐ݒ
	 */
    define_int_plevel(TMU0_INTEVT,KTIM_INT_LV); /* 荞݃xݒ(SF) */
    /* 荞݃xݒ(HW) */
    sil_wrh_mem((VP)IPRA,
                ((sil_reh_mem((VP)IPRA) & 0x0fff) | (KTIM_INT_LV<<12)));
    /* 荞ݗvNA */
    sil_wrh_mem((VP)TMU_TCR0,
                (sil_reh_mem((VP)TMU_TCR0) & ~TCR_UNF));
}


/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
    /* 荞ݗvNA */
    sil_wrh_mem((VP)TMU_TCR0,
                (sil_reh_mem((VP)TMU_TCR0) & ~TCR_UNF));    
}

/*
 *  ^C}̒~
 */
Inline void
hw_timer_terminate()
{
    /* ^C}~ */
    sil_wrb_mem((VP)TMU_TSTR,
                (sil_reb_mem((VP)TMU_TSTR) & ~TMU_STR0));
    /* 荞ݗvNA */
    sil_wrh_mem((VP)TMU_TCR0,0);
}

/*
 *  ^C}̌ݒl̓ǂ݂
 *
 *  ݋֎~ԒŌĂяoƁD
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)TMU_TCNT0));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_reh_mem((VP)TMU_TCR0) & TCR_UNF);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */



