/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_insn.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *  vZbT̓ꖽ߂̃CC֐`iSH3/4pj
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_


/*
 *  Xe[^XWX^iSRǰݒl̓Ǐo
 */
Inline UW
current_sr(void)
{
    UW	sr;
    Asm("stc  sr,%0" : "=r"(sr));
    return(sr);
}


/*
 *  Xe[^XWX^iSRǰݒl̕ύX
 */
Inline void
set_sr(UW sr)
{
	Asm("ldc %0, sr" : : "r"(sr) );
}


/*
 *  NMIׂĂ݂̊֎~
 */
Inline void
disint(void)
{
    set_sr((current_sr() & ~0x000000f0) |  MAX_IPM << 4 );
}


/*
 *  ׂĂ݂̊
 */
Inline void
enaint()
{
    set_sr(current_sr() & ~0x000000f0);
}

/*
 *  xN^x[XWX^iVBRǰݒl̓Ǐo
 */
Inline VP
current_vbr(void)
{
    VP	vbr;
	Asm("stc vbr,%0" : "=r"(vbr));
	return(vbr);
}


/*
 *  xN^x[XWX^iVBRj̐ݒ
 */
Inline void
set_vbr(VP vbr)
{
    Asm("ldc  %0, vbr" : : "r"(vbr) );
}


#endif /* _CPU_INSN_H_ */




