/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *  vZbTˑW[iSH3/4pj
 */
#include <s_services.h>
#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ^XNReLXgł̊݃}XN
 */
#ifdef SUPPORT_CHG_IPM
UW	task_intmask;
#endif /* SUPPORT_CHG_IPM */


/*
 *  ^XNReLXgł̊݃}XN
 */
UW	int_intmask;


/*
 * 荞݃nh/Dx̋^e[u
 */
FP  int_table[(MAX_INTIVT>>5) + 1];
VW  int_plevel_table[(MAX_INTIVT>>5) + 1];


/*
 * CPUOnh̋^e[u
 */
FP	exc_table[(0x1E0 >> 5) + 1];


/*
 *  vZbTˑ̏
 */
void
cpu_initialize()
{
    int i;
    
    /*
     *  ^XNReLXgł̊݃}XN̏
     */
#ifdef SUPPORT_CHG_IPM
    task_intmask = 0x0000;    
#endif /* SUPPORT_CHG_IPM */
    
    /*
     * int_table[],int_plevel_table[]̏
     * o^̊ݔcpu_interrup()Ăяo悤
     * no_reg_interrup()o^
     * fBtHgint_plevel_table[]̊ݗDxMAX_IPM - 1
     * ƂD
     */
    for(i = 0; i < ((MAX_INTIVT>>5) + 1); i++){
        int_table[i] = no_reg_interrupt;
        int_plevel_table[i] = 0x40000000 | (MAX_IPM - 1) << 4;
    }
    
#ifndef GDB_STUB
    /*
     * 荞݃Rg[̏ 
     */
#if defined(SH7750)
    sil_wrh_mem((VP)ICR, 0x0000);
    sil_wrh_mem((VP)IPRA, 0x0000);
    sil_wrh_mem((VP)IPRB, 0x0000);
    sil_wrh_mem((VP)IPRC, 0x0000);
#else /* SH7708 || SH7709 || SH7709A || SH7729R || SH7727 */   
    sil_wrh_mem((VP)ICR0, 0x0000);
    sil_wrh_mem((VP)IPRA, 0x0000);     
    sil_wrh_mem((VP)IPRB, 0x0000);
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
    sil_wrh_mem((VP)ICR1, 0x4000);
    sil_wrh_mem((VP)ICR2, 0x0000);     
    sil_wrh_mem((VP)PINTER, 0x0000);
    sil_wrh_mem((VP)IPRC, 0x0000);
    sil_wrh_mem((VP)IPRD, 0x0000);
    sil_wrh_mem((VP)IPRE, 0x0000);
    sil_wrb_mem((VP)IRR0, 0x0000);   
    sil_wrb_mem((VP)IRR1, 0x0000);
    sil_wrb_mem((VP)IRR2, 0x0000);
#endif /* SH7709 || SH7709A  */   
#endif /* SH7750 */
    
    /*
     *  xN^x[XWX^[̏
     */
    set_vbr(BASE_VBR);
    
#endif /* GDB_STUB */
}


/*
 *  vZbTˑ̏I
 */
void
cpu_terminate()
{
}


/*
 * TrapaȊO̗Oœo^ĂȂOƌĂяo
 */
void
cpu_expevt(VW expevt,VW spc,VW ssr,VW pr)
{
    syslog(LOG_EMERG, "Unregistered Expevt error occurs.");
    syslog(LOG_EMERG, "Expevt = %08x SPC = %08x SR = %08x PR=%08X",
           expevt,spc,ssr,pr);
    while(1);
}

/*
 * o^݂̊ꍇɌĂяo
 */
void
cpu_interrupt(VW intevt, VW intevt2,VW spc,VW ssr)
{
    syslog(LOG_EMERG, "Unregistered Interrupt occurs.");
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
    syslog(LOG_EMERG, "INTEVT = %08x INTEVT2 = %08x SPC = %08x SR = %08x ",
           intevt,intevt2,spc,ssr);
#else /* SH7708 || SH7750 */   
    syslog(LOG_EMERG, "INTEVT = %08x  SPC = %08x SR = %08x ",intevt,spc,ssr);
#endif    
    while(1);
}



#ifdef SUPPORT_CHG_IPM

/*
 *  ݃}XN̕ύX
 *
 *  chg_ipm g IPM  MAX_IPM iNMI X^u[gu[N ȊO
 *  ׂ̂Ă݂̊֎~jȏɕύX邱Ƃ͂łȂDNMI X^u
 *  [gu[NȊÔׂĂ݂̊֎~ꍇɂ́Aloc_cpu 
 *  CPUbNԂɂ΂悢DIPM  0 ȊO̎ɂC^XNfBX
 *  pb`͕ۗȂDIPM ́C^XNfBXpb`ɂāCV
 *  sԂɂȂ^XNֈpD̂߁C^XNsɁC
 *  ̃^XNɂ IPM ύXꍇDJSPJ[lł́CIPM
 *  ̕ύX̓^XNO[`ɂĂN̂ŁCɂĈ
 *  Ȃ󋵂͏ȂƎvDIPM ̒lɂă^XNfBX
 *  pb`֎~ꍇɂ́Cdis_dsp 𕹗p΂悢D
 */

SYSCALL ER
chg_ipm(IPM ipm)
{
    ER  ercd;
    
    LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_PAR(0 <= ipm && ipm <= MAX_IPM - 1);

	t_lock_cpu();
	task_intmask = (ipm << 4);
    ercd = E_OK;
	t_unlock_cpu();

  exit:
    LOG_CHG_IPM_LEAVE(ercd);
    return(ercd);
}


/*
 *  ݃}XN̎Q
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
    ER  ercd;

    LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_ipm = (task_intmask >> 4);
    ercd = E_OK;
	t_unlock_cpu();

  exit:
    LOG_GET_IPM_LEAVE(ercd, *p_ipm);
    return(ercd);
}

#endif /* SUPPORT_CHG_IPM */
