/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *	vZbTˑW[iSH1pj
 *@@@@@J[lŎgp`
 *@@@@@@f[^^A}NA֐̃vg^Cv錾
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  SH1vZbT̓WX^̒`
 */
#include <sh1.h>

/*
 *  lf[^񉻗p}N̒`
 */
#include <util.h>

/*
 *  [U[`
 */
#include <user_config.h>

/*
 *  ݒ\ȍōDx
 */
#ifdef GDB_STUB
#define MAX_IPM  0xe	/* X^ȕꍇ͗Dx14CPUbN   */
#else
#define MAX_IPM  0xf	/* X^uȂ̏ꍇ͍ōDxCPUbN */
#endif /*  GDB_STUB  */

#define str_MAX_IPM  		TO_STRING(MAX_IPM)

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */

#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 *  
 *  @spUW *^ƂĂ̂4oCgEӎĂ邽
 *  
 */
typedef struct task_context_block {
        UW 	*sp;            /* X^bN|C^ */
        FP	pc;             /* vOJE^ */
} CTXB;

/*
 *  ݃}XN색Cu
 *
 *  ݃}XNiintmaskj́CIPMiInterrupt Priority Maskj4rbg
 *  ɃVtĝłD
 */

/*
 *  ݂̊݃}XN̓Ǐo
 */
Inline UW
current_intmask(void)
{
	return(current_sr() & 0x000000f0u);
}

/*
 *  ݃}XN̐ݒ
 */
Inline void
set_intmask(UW intmask)
{
	set_sr((current_sr() & ~0x000000f0u) | intmask);
}


/*
 *  ݁^CPUOlXgJE^
 */
extern UW	intnest;

/*
 *  VXeԎQ
 */


/*
 *  ReLXgQ
 *
 *  ݃lXgJE^ǂݏoɊ݂ĂA
 *  ߂Ƃɂ̓ReLXgɖ߂Ă
 */
Inline BOOL
sense_context(void)
{
	return(intnest > 0);
}

Inline BOOL
sense_lock(void)
{
	return(current_intmask() == (MAX_IPM << 4));
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ctask_intmask  0 ɂȂĂƍl΂悢D
 */

#ifdef SUPPORT_CHG_IPM
extern UW	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(viod)
{
	disint();		/*  cpu_insn.h  */
}

Inline void
t_unlock_cpu(void)
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽
	 *  ߁C̓r task_intmask 邱Ƃ͂ȂD
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();		/*  cpu_insn.h  */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern UW	int_intmask;	/* ^XNReLXgł̊݃}XN */

Inline void
i_lock_cpu(void)
{
	UW	intmask;

	/*
	 *  ꎞϐ intmask gĂ̂́Ccurrent_intmask() 
	 *  񂾒Ɋ݂CNꂽ݃nh
	 *  int_intmask ύX\邽߂łD
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}

Inline void
i_unlock_cpu(void)
{
	set_intmask(int_intmask);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

#endif /* _MACRO_ONLY */

/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*
 *  OxN^e[u̒`
 *  @@}N̐
 *  @@@KERNEL_HAS_A_VECTOR_TABLE
 *  @@@@J[lOxN^e[u
 *  @@@SIO_RESERVED
 *  @@@@VAfoCXfobKɂĎgpĂ
 */
#ifndef _MACRO_ONLY

#ifdef KERNEL_HAS_A_VECTOR_TABLE
extern FP vector_table[];	/*  OxN^e[u  */
#endif /* KERNEL_HAS_A_VECTOR_TABLE */


/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
#ifdef GDB_STUB
	/*  X^uĂяo  */
	Asm("mov   #0x08,r0;	\
	     mov   %0,r4;	\
	     mov   %1,r5;	\
	     trapa #0x21"
               : /* no output */
               : "r"(inhno),"r"(inthdr)
               : "r0","r4","r5");

#else	/*  GDB_STUB  */

#ifdef KERNEL_HAS_A_VECTOR_TABLE

#ifdef SIO_RESERVED	/*  VA荞݂͔  */
	if ((inhno != RXI0) && (inhno != TXI0))
#endif /* SIO_RESERVED */
		vector_table[inhno] = inthdr;

#endif /* KERNEL_HAS_A_VECTOR_TABLE */

#endif	/*  GDB_STUB  */
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
extern void define_exc(EXCNO excno, FP exchdr)  throw();


/*
 *  ݃nh^CPUOnh̓
 */

/*  Cꃋ[`̊֐̃x𐶐  
 *     kernel_cfg.cŎgp
 */
#define	INT_ENTRY(inthdr)	_kernel_##inthdr##_entry
#define	EXC_ENTRY(exchdr)	_kernel_##exchdr##_entry

/*
 *  ݃nh^CPUOnh̓̋ʕ
 *
 *	SH1ł́A݂CPUÖقƂǓȂ̂ŁA
 *	̃}Nʂɒ`Ă
 *
 *@@
 *	labelF̃x
 *	inthdrFCꃋ[`̐擪AhX
 *	common_routineFcpu_support.S̕AhX
 *			interrupt_entryF݂̏ꍇ
 *			cpu_exception_entryFCPUȌꍇ
 *
 *@@WX^
 *@@@@r1FݎtSR̃Rs[
 *@@@@r0Finterrupt_entry
 *@@@@r2FCꃋ[`̐擪AhX
 *
 *	݂CPUȎ_
 *	@@ECPUOnhɈ^
 *	@@ECPUOł́AOIPMƓlŊ݂
 *		iCPUOɂAIPMωȂj
 *
 *	@@E݃nh̏ꍇ				
 *	@@  	ݎtɃn[hEFAIPMݒ肷	
 *	@@  	݋ɂ͂IPM̒lp		
 *	@@ECPUOnh̏ꍇ				
 *	@@  	CPUOtIPM̒l͕ωȂ		
 *	@@  	݋ɂCPUOIPM̒lp	
 */
#define	HANDLER_ENTRY_PROC(label, handler, common_routine)		   \
asm(".text;								  "\
"	.align 2;							  "\
"	.global _"#label";						  "\
"_"#label":;								  "\
			/*  Kvŏ̃WX^X^bNɑҔ  */	   \
"	mov.l	r0,@-r15;						  "\
"	mov.l	r1,@-r15;						  "\
				/*  ݋֎~SȐ  		*/ \
"	stc	sr,r1;							  "\
	/*  ݋֎~  						*/ \
	/*     ݂֎~Oɕʂ݂̊ꍇ̒ӓ_ 	*/ \
	/*     cpu_suppourt.Sret_intQ 				*/ \
"	mov.l	_mask_ipm_"#handler",r0;				  "\
"	ldc	r0,sr;							  "\
"	mov.l	r2,@-r15;						  "\
"	mov.l	_common_routine_"#handler",r0;				  "\
"	mov.l	_c_routine_"#handler",r2;" /* Cꃋ[`̐擪AhX*/\
"	jmp	@r0;		"/*  interrupt_entryփWv 		*/ \
"	nop;				"	/*  xXbg  	*/ \
	/* l 							*/ \
	/* @xXbgPC΃AhbVÕ[h߂ 		*/ \
	/* @ƌ듮삷B 					*/ \
	/*  @iXbgsߗOȂ̂ŔBj 	*/ \
									   \
"	.align 2;							  "\
"_mask_ipm_"#handler":;	    "	/*  ݋֎~p}XN  		*/ \
"	.long  "str_MAX_IPM" << 4; "	/*  ipmȊÕrbg̓[ŗǂ	*/ \
"_c_routine_"#handler":;	    					  "\
"	.long  _"#handler";   "	/* Cꃋ[`̐擪AhX  	*/ \
"_common_routine_"#handler":; "	/* cpu_support.S̕AhX	*/ \
"	.long  __kernel_"#common_routine"; "		  		   \
)

/*
 *  ݃nh̓̐}N
 *
 */
#define INTHDR_ENTRY(inthdr)	INTHDR_ENTRY2(INT_ENTRY(inthdr), inthdr)

#define INTHDR_ENTRY2(entry, inthdr)					\
	extern void entry(void);					\
	HANDLER_ENTRY_PROC(entry, inthdr, interrupt_entry)


/*
 *  CPUOnh̓̐}N
 */
#define	EXCHDR_ENTRY(exchdr)	EXCHDR_ENTRY2(EXC_ENTRY(exchdr), exchdr)

#define EXCHDR_ENTRY2(entry, exchdr)					\
	extern void entry(void);					\
	HANDLER_ENTRY_PROC(entry, exchdr, cpu_exception_entry)
	/*
	 *  void entry()͒PȂGg̃xȂ̂ŁA
	 *  ͕tȂ
	 */

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg̎Q
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	/* 
	 *  PƔr̂́AݎsCPUO̕
	 *  ݃lXgJE^CNgĂ邽 	
	 *  
	 *  CPUO̓ɕʂCPUO͔ȂƉ
	 *  Ă
	 */
	return(intnest > 1);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	UW sr = *(UW *)p_excinf; 
	return((sr& 0x00000f0u) == (MAX_IPM << 4));
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);


/*
 *  L̃Oõ͎X^bN\̒`
 */
typedef struct exc_stack {
	VW	r0;
	VW	r1;
	VW	r2;
	VW	r3;
	VW	r4;
	VW	r5;
	VW	r6;
	VW	r7;
	VW	r8;
	VW	r9;
	VW	r10;
	VW	r11;
	VW	r12;
	VW	r13;
	VW	r14;
	VW	r15;
	VW	pr;	/*  vV[WEWX^  	*/
	VW	pc;	/*  vOEJE^  	*/
	VW	sr;	/*  Xe[^XEWX^  	*/
} EXCSTACK;


/*
 * ÕOo (cpu_config.c, cpu_support.S)
 */
extern void     cpu_experr(EXCSTACK *);

#endif /* _MACRO_ONLY */


/*
 *  OxN^ɐݒ肷ftHg̒l
 *  	ȉ̗OvŃftHgƂ͈قȂOxN^`
 *	ꍇ́Asys_config.hŊY}N`B
 */
#define RESET_VECTOR 	start		/*  ZbgxN^  */
#define INIT_STACK  	STACKTOP	/*  X^bN|C^̏l  */

#define RESERVED_VECTOR	RESET_VECTOR	/*  VXe\̃ZbgxN^  */
					/*  ۂɂ͎gpȂ  */

#ifndef GII_VECTOR	/*  ʕs  */
#define GII_VECTOR	RESET_VECTOR
#endif /* GII_VECTOR */

#ifndef SII_VECTOR	/*  Xbgs  */
#define SII_VECTOR	RESET_VECTOR
#endif /* SII_VECTOR */

#ifndef CAE_VECTOR	/*  CPUAhXG[  */
#define CAE_VECTOR	RESET_VECTOR
#endif /* CAE_VECTOR */

#ifndef DAE_VECTOR	/*  DMAAhXG[  */
#define DAE_VECTOR	RESET_VECTOR
#endif /* DAE_VECTOR */

#ifndef NMI_VECTOR	/*  NMI  */
#define NMI_VECTOR	RESET_VECTOR
#endif /* NMI_VECTOR */


#endif /* _CPU_CONFIG_H_ */
