/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 * ^[QbgˑVAI/OW[(DMT33209)
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include "s_services.h"

/*
 *  VAI/O̊݃nh̃xN^ԍ
 */
#define INHNO_SERIAL_IN		S1C33_INHNO_SERIAL0RX
#define INHNO_SERIAL_OUT	S1C33_INHNO_SERIAL0TX
#define INHNO_SERIAL_ERR	S1C33_INHNO_SERIAL0ERR

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND		1	/* M\R[obN	*/
#define SIO_ERDY_RCV		2	/* MʒmR[obN	*/

#define INDEX_SIO(sioid)	((UINT)((sioid) - 1))

/*
 *  SIO荞ݗvtO rbgʒu
 */
#define SIO_INT_ERR		0x01
#define	SIO_INT_RCV		0x02
#define	SIO_INT_SND		0x04

/*
 * G[tO rbgʒu
 */
#define SIO_ERR_FRAME		0x10
#define SIO_ERR_PARITY		0x08
#define SIO_ERR_OVERRUN		0x04

#ifndef _MACRO_ONLY
/*
 *	VA|[g̃n[hEFAˑ̒`
 */
typedef struct {
	UB	ch_no;		/* SIO`lԍ		*/
	UB	err_vector;	/* ʐMG[荞݃xN^ԍ	*/
	UB	rx_vector;	/* M荞݃xN^ԍ	*/
	UB	tx_vector;	/* M荞݃xN^ԍ	*/
} SIOPINIB;

/*
 *  VA|[g̐ubN
 */
typedef struct {
	const SIOPINIB	*inib;		/* ubN	*/
	VP_INT		exinf;		/* g		*/
	BOOL		openflag;	/* I[vς݃tO	*/
	BOOL		tx_cbrflag;	/* MR[obNstO*/
	BOOL		rx_cbrflag;	/* MR[obNstO*/
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  O֐̎Q
 */
extern void	sio_initialize (void);
extern void	sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn);
extern void	sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn);
extern void	serial_handler_in(ID portid);
extern void	serial_handler_out(ID portid);
extern void	sio_ierdy_snd(VP_INT exinf);
extern void	sio_ierdy_rcv(VP_INT exinf);
extern ER	ena_int(INTNO);
extern ER	dis_int(INTNO);

/*
 *  VA|[g̏
 */
Inline SIOPCB
*sio_opn_por(ID siopid, VP_INT exinf)
{
	B	temp;

	/*
	 *  荞݂̋֎~
	 */
	if(siopid == 1){
		dis_int(S1C33_INHNO_SERIAL0RX);
		dis_int(S1C33_INHNO_SERIAL0TX);
#ifdef SIO_ERR_HANDLER
		dis_int(S1C33_INHNO_SERIAL0ERR);
#endif
	} else {
		dis_int(S1C33_INHNO_SERIAL1RX);
		dis_int(S1C33_INHNO_SERIAL1TX);
#ifdef SIO_ERR_HANDLER
		dis_int(S1C33_INHNO_SERIAL1ERR);
#endif
	}

	/*
	 *  VAI/F̐ݒ
	 *
	 *  8bit  peBȂ Xgbvrbg1bit  ONbN
	 */
	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bControl = 0x07;

	((s1c33Port_t *)S1C33_PORT_BASE)->stPPort[INDEX_SIO(siopid)].bFuncSwitch = 0x07;
	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bIrDA = 0x00;

	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bControl = 0xc7;

	/*
	 *  ݗvNA
	 */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[6] |= (0x07 << INDEX_SIO(siopid));

	/*
	 *  Mobt@̃NA
	 */
	temp = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bRxd;

	/*
	 *  ̐ݒ
	 */
	siopcb_table[INDEX_SIO(siopid)].openflag = TRUE;
	if(exinf != NULL){
		siopcb_table[INDEX_SIO(siopid)].exinf = exinf;
	}

	/*
	 *  荞݂̋
	 */
	if(siopid == 1){
		ena_int(S1C33_INHNO_SERIAL0RX);
		ena_int(S1C33_INHNO_SERIAL0TX);
#ifdef SIO_ERR_HANDLER
		ena_int(S1C33_INHNO_SERIAL0ERR);
#endif
	} else {
		ena_int(S1C33_INHNO_SERIAL1RX);
		ena_int(S1C33_INHNO_SERIAL1TX);
#ifdef SIO_ERR_HANDLER
		ena_int(S1C33_INHNO_SERIAL1ERR);
#endif
	}

	return (&(siopcb_table[INDEX_SIO(siopid)]));
}

/*
 *  ʐM̒~
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	UB	ch_no;

	ch_no = siopcb->inib->ch_no;
	/*
	 *  ]҂
	 */
	while(((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus & 0x20){
		;
	}

	/*
	 *  ʐM֎~
	 */
	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bControl = 0x07;

	return;
}

/*
 *  M@\̏Ԃ擾
 */
Inline BOOL
sio_get_txready(UB ch_no)
{
	UB	bSioSts;

	bSioSts = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus;

	return(!(bSioSts & 0x20));
}

/*
 *  M@\̏Ԃ擾
 */
Inline BOOL
sio_get_rxready(UB ch_no)
{
	UB	bSioSts;

	bSioSts = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus;

	return(bSioSts & 0x01);
}

/*
 *  M1ǂݍ
 */
Inline INT
sio_rcv_chr(SIOPCB *siopcb)
{
	BOOL	blRxSts;
	UB	ch_no;


	ch_no = siopcb->inib->ch_no;
	blRxSts  = sio_get_rxready(ch_no);

	if(blRxSts){
		return (((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bRxd);
	}

	return (-1);
}

/*
 *  M1
 */
Inline BOOL
sio_snd_chr(SIOPCB *siopcb, char c)
{
	BOOL	blTxSts;
	UB	ch_no;

	ch_no = siopcb->inib->ch_no;
	blTxSts = sio_get_txready(ch_no);
	if(blTxSts){
		((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bTxd = c;
	}

	return(blTxSts);
}

/*
 *  w肳ꂽSIO`l̊荞ݗvNA
 */
Inline void
sio_clr_factor(UB bFlag)
{
	((volatile s1c33Intc_t *) S1C33_INTC_BASE)->bIntFactor[6] |= bFlag;
}

/*  w肳ꂽSIO`l̃G[tONA
 *
 */
Inline void
sio_clr_errflag(UB ch_no)
{
	((volatile s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus
		&= ~(SIO_ERR_OVERRUN | SIO_ERR_PARITY | SIO_ERR_FRAME);
}

#endif /* _MACRO_ONLY   */
#endif /* _HW_SERIAL_H_ */
