/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: pit.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^C}hCo
 *@@@@@MPC860T̎݃^C}PITgp
 */

#ifndef _PIT_H_
#define _PIT_H_

#include <mpc860_sil.h>

/*
 *  SIU̓݃xirbgp^[j
 */
#define SIU_INT_PIT	LEVEL_TO_BIT_PATTERN(INTLVL_PIT)


/*
 *  ^C}l̓\̌^
 */
typedef UH	CLOCK;

/*
 *	^C}ɋNbNg[kHz]
 *   	TIMER_CLOCK=SYSTEM_CLOCK[MHz] / 4
 */
#define	TIMER_CLOCK		(SYSTEM_CLOCK * 1000 / 4)

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) (TO_CLOCK(TIC_NUME, TIC_DENO) - 1))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define	MAX_CLOCK	((CLOCK) 0xffffu)

/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define	GET_TOLERANCE	100	/* x̌ςliPʂ͓\j*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  Rg[WX^̒`
 */

/*  ݃Xe[^Xѐ䃌WX^  */
#define PISCR       (VH *)(IMMR_BASE + 0x240)
#define PISCRK      (VW *)(IMMR_BASE + 0x340)  /*  L[WX^  */
#define PISCR_PIRQ  0xff00      /*  ݗvxrbg  */  
#define PISCR_PS    BIT8_16     /*  ݃Xe[^X  */    
#define PISCR_PIE   BIT13_16    /*  ݃Cl[u  */
#define PISCR_PITF  BIT14_16    /*  PITt[YECl[u  */
#define PISCR_PTE   BIT15_16    /*  ^C}ECl[u  */

/*  PITJEgWX^i2oCĝ݁j  */
#define PITC        (VH *)(IMMR_BASE + 0x244)
#define PITCK       (VW *)(IMMR_BASE + 0x344)  /*  L[WX^  */

/*  PITWX^i2oCĝ݁j  */
#define PITR        (VH *)(IMMR_BASE + 0x248)



#ifndef _MACRO_ONLY

/*
 *  WX^ی̃bNƃAbN
 */

/*  PISCRbN  */
Inline void
lock_piscr()
{
    	/*  lUNLOCK_KEYȊOłΗǂ  */
    mpc860_wrw_mem(PISCRK, 0);
}

/*  PISCRAbN  */
Inline void
unlock_piscr()
{
    mpc860_wrw_mem(PISCRK, UNLOCK_KEY);
}

/*  PITCbN  */
Inline void
lock_pitc()
{
    	/*  lUNLOCK_KEYȊOłΗǂ  */
    mpc860_wrw_mem(PITCK, 0);
}

/*  PITCAbN  */
Inline void
unlock_pitc()
{
    mpc860_wrw_mem(PITCK, UNLOCK_KEY);
}

/*
 *  ^C}X^[g
 */
Inline void
pit_start()
{
    unlock_piscr();         	/*  PISCRAbN  */
    mpc860_orh_mem(PISCR, PISCR_PTE);
    lock_piscr();         	/*  PISCRbN  */
}

/*
 *  ^C}ꎞ~
 */
Inline void
pit_stop()
{
    unlock_piscr();         	/*  PISCRAbN  */
    mpc860_andh_mem(PISCR, ~PISCR_PTE);
    lock_piscr();         	/*  PISCRbN  */
}

/*
 *  ^C}ݗṽNA
 *          PISCRWX^PSrbg1
 */
Inline void
pit_int_clear()
{
	/*
	 *  SILgpƂ̃O@\It
	 */
#ifdef SIL_DEBUG
    BOOL sil_debug_tmp = sil_debug_on;
    sil_debug_on = FALSE;
#endif /* SIL_DEBUG */

    unlock_piscr();         	/*  PISCRAbN  */
    mpc860_orh_mem(PISCR, PISCR_PS);
    lock_piscr();         	/*  PISCRbN  */

	/*
	 *  SILgpƂ̃O@\𕜌
	 */
#ifdef SIL_DEBUG
    sil_debug_on = sil_debug_tmp;
#endif /* SIL_DEBUG */

}


/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
pit_initialize()
{
    VH piscr;
    VW sccr;
    
    /* ^C}l=ϐ̍őlȂ̂Ń`FbN͏ȗ */

    pit_stop();		/* ^C}~ */
    
    /*
     *  ^C}֘A̐ݒ
     */
    
    /*  NbN\[XIAݒ  */
    unlock_sccr();              /*  SCCRAbN  */
    sccr = mpc860_rew_mem(SCCR);
    sccr = (sccr & ~SCCR_RTDIV) /*  A^CNbN:4  */
            | SCCR_RTSEL;       /*  NbN\[XFEXTCLK  */
    mpc860_wrw_mem(SCCR, sccr);
    lock_sccr();                /*  SCCRbN  */


    /*  JE^ڕWlݒ  */
    unlock_pitc();                  /*  PITCAbN  */
    mpc860_wrh_mem(PITC, CLOCK_PER_TICK);
    lock_pitc();                    /*  PITCbN  */
    
    
    unlock_piscr();                 /*  PISCRAbN  */
    piscr = mpc860_reh_mem(PISCR);
    piscr = (piscr & ~PISCR_PIRQ)
            | (SIU_INT_PIT << 8)	/*  ݃xݒ  */
            | PISCR_PIE;                /*  PIT݋  */
    mpc860_wrh_mem(PISCR, piscr);
    lock_piscr();                   /*  PISCRbN  */
}

/*
 *  ^C}̒~
 *
 *  @^C}̓~D
 */
Inline void
pit_terminate()
{
    pit_stop();				/* ^C}~ 	*/
    pit_int_clear();			/* 荞ݗvNA */

    unlock_piscr();                 	/*  PISCRAbN  */
    mpc860_andh_mem(PISCR, ~PISCR_PIE);	/* ^C}݂֎~   */
    lock_piscr();                   	/*  PISCRbN  */
    
    /*  {̓^C}ւ̃NbN~  */
}

/*
 *  ^C}̌ݒl̓Ǐo
 *@@@݋֎~ԒŌĂяo
 */
Inline CLOCK
pit_get_current()
{
    CLOCK pitr;
    
    pitr = mpc860_reh_mem(PITR);
    return(CLOCK_PER_TICK - pitr);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
pit_fetch_interrupt()
{
    VH piscr;
    
    /*  ǂݏoȂ̂ŁAAbNȂėǂ  */
    piscr = mpc860_reh_mem(PISCR);
    return(piscr & PISCR_PS);
}

#endif /* _MACRO_ONLY */
#endif /* _PIT_H_ */
/*  end of file  */
