/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^C}hCoiMPC860Tpj
 *@@@@@MPC860T̎݃^C}PITgp
 *
 *@@@@@݃Rg[ˑ͂̃t@CɋLq
 *@@@@@^C}foCX̂Ɉˑ鏈pit.hɋLq
 *
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

#ifndef _MACRO_ONLY
#include <pit.h>
#endif /* _MACRO_ONLY */

/*  ^C}݃nh̃xN^ԍ  */
#define	INHNO_TIMER	LEVEL_TO_INHNO(INTLVL_PIT)

/*  ^C}݂IPM  */
#define	IPM_PIT		LEVEL_TO_IPM(INTLVL_PIT)

/*  ^C}݂̋rbg  */
#define	ENABLE_PIT	LEVEL_TO_ENABLE_BIT(INTLVL_PIT)


#ifndef _MACRO_ONLY

/*
 *  ^C}ݗṽNA
 */
#define hw_timer_int_clear	pit_int_clear


/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
	/*
	 *  ^C}foCX̂̏
	 */
	pit_initialize();

	/*
	 *  VXeC^[tF[XjbgSIUIPM
	 */
	mpc860_orh_mem(SIMASK, ENABLE_PIT);

	/*
	 *  J[l̃f[^
	 */
	define_ipm(INHNO_TIMER, IPM_PIT);	/* IPM̐ݒ@*/

	
	pit_int_clear();	/*  ݗvNA  */
	pit_start();		/*  ^C}X^[g    	*/
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
#define hw_timer_terminate		pit_terminate

/*
 *  ^C}̌ݒl̓Ǐo
 *@@@^C}̓ꎞIɒ~C^C}lǂݏoD
 */
#define hw_timer_get_current		pit_get_current

/*
 *  ^C}ݗṽ`FbN
 */
#define hw_timer_fetch_interrupt	pit_fetch_interrupt

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
/*  end of file  */
