/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

/*
 * CPUˑ^C}W[iNios2pj
 */ 
#include <s_services.h>
#include <nios2.h>

/*
 * ^C}݃nh̊ݔԍ
 */
#define INHNO_TIMER TIM_INTLVL

#ifndef _MACRO_ONLY

/*
 * ^C}l̓\̌^
 */
typedef UW CLOCK;

/*                                                                             
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ                               
 *  TIMER_CLOCK ̓^[Qbg{[hɐݒ                                     
 */
#define TO_CLOCK(nume, deno)  (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ݒłő^C}iPʂ͓\j
 */
#define MAX_CLOCK ((CLOCK) 0xffffffff)

/*
 *  \]pVXeoۂ̏Ԃ̌ςliPʂ͓\j
 */
#define GET_TOLERANCE	100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 * ^C}̋N
 *
 * ^C}CIȃ^C}݂𔭐
 */ 
Inline void
hw_timer_initialize(void)
{
  
    CLOCK cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

    /* ^C}[Xgbv */
    sil_wrw_mem((VP)TIM_CONTROL,TIM_CONTROL_STOP);
    /* ^CAEgXe[^XNA */
    sil_wrw_mem((VP)TIM_STATUS, 0x00);
    
      
    assert(cyc <= MAX_CLOCK);                          /* ^C}l̃`FbN */
    sil_wrw_mem((VP)TIM_PERIODL, (cyc & 0xffff)); /* JE^[Zbg 16bit */
    sil_wrw_mem((VP)TIM_PERIODH, (cyc >> 16));    /* JE^[Zbg 16bit */
  
    /*
     * ^C}[X^[gCI[g[hC݋
     */
    sil_wrw_mem((VP)TIM_CONTROL, TIM_CONTROL_START
                                 |TIM_CONTROL_COUNT|TIM_CONTROL_ITO);

    /*
     * ݃Rg[̋
     */
    ena_int(TIM_INTLVL);
}


/*
 *   ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
    /* TOrbg̃NA */
    sil_wrw_mem((VP)TIM_STATUS,0x00);
}


/*
 *   ^C}̋֎~
 */
Inline void
hw_timer_terminate()
{
    /* ^C}~ */
    sil_wrw_mem((VP)TIM_CONTROL, TIM_CONTROL_STOP);

    /* ݗṽNA */
    sil_wrw_mem((VP)TIM_STATUS, 0x00);
}


/*
 *   ^C}̌ݒl̓ǂݏo
 *
 *   ݋֎~ԒŌĂяo
 */
Inline CLOCK
hw_timer_get_current(void)
{
    CLOCK count;

    /* XibvWX^ɏނƒlz[h */
    sil_wrw_mem((VP)TIM_SNAPL, 0x00);

    /* JEglǂݍ */
    count = sil_rew_mem((VP)TIM_SNAPL);
    count |= sil_rew_mem((VP)TIM_SNAPH) << 16; 
    
    return(TIMER_CLOCK - count);
}


/*
 *   ݂Ă邩̔
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
    return(sil_rew_mem((VP)TIM_STATUS) & TIM_STATUS_TO);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
