/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _UPD71054_H_
#define _UPD71054_H_

#include <s_services.h>

/*
 *  ^C} uPD71054(NEC) ֘A̒`
 */

/* uPD71054̃WX^̃AhX */
#define PCNT0		0x00
#define PCNT1		0x10
#define PCNT2		0x20
#define PCNTL		0x30

/* control word foemat */
#define BINARY			0u	/* BIT0 */
#define BCD			BIT0

#define MODE_0			0u	/* BIT1, 2, 3 */
#define MODE_1			BIT1
#define MODE_2			BIT2
#define MODE_3			(BIT2 | BIT1)
#define MODE_4			BIT3
#define MODE_5			(BIT3 | BIT1)

#define COUNT_LATCH_COMM	0u	/* BIT5, 4 */
#define LOWER_BYTE		BIT4
#define HIGH_BYTE		BIT5
#define LOW_HIGH_BYTE		(BIT5 | BIT4)

#define COUNTER_0		0u	/* BIT6, 7 */
#define COUNTER_1		BIT6
#define COUNTER_2		BIT7
#define MULT_LATCH_COMM		(BIT7 | BIT6)

/* multiple latch command format */
#define SEL_COUNTER_0		BIT1
#define SEL_COUNTER_1		BIT2
#define SEL_COUNTER_2		BIT3
#define DO_NOT_LATCH_STATUS	BIT4
#define LATCH_STATUS		0u	/* BIT4 */
#define DO_NOT_LATCH_COUNT	BIT5
#define LATCH_COUNT		0u	/* BIT5 */

/*
 *  ^C}̃WX^ւ̃ANZX֐
 */
#define upd71054_reb( addr )		sil_reb_mem( (VP)(TIMER_BASE_ADDR + addr) )
#define upd71054_wrb( addr, val )	sil_wrb_mem( (VP)(TIMER_BASE_ADDR + addr), val )

#endif /* _UPD71054_H_ */
