/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <sys_rename.h>

/*
 *  ݃Rg[E{[hˑ̃CN[ht@C̓ǂݍ
 */
#include <pic_icu.h>	/* ݃Rg[֌W̏<CPU>ɓn */
#include <vr5500.h>	/* NOP_FOR_CP0_HAZARD̏cpu_support.Sɓn */

/*
 *  vgxet_tim T|[g邩ǂ̒`
 */
#define	SUPPORT_VXGET_TIM

/*
 *  VA|[g̒`
 */
#ifndef GDB_STUB
#define TNUM_SIOP	2u	/* T|[gVA|[g̐ */
#define TNUM_PORT	2u	/* T|[gVAI/O|[g̐ */
#else  /* GDB_STUB */
#define TNUM_SIOP	1u	/* T|[gVA|[g̐ */
#define TNUM_PORT	1u	/* T|[gVAI/O|[g̐ */
				/* GDB_STUB 𗘗pƂ́ASCC1 GDB_STUB 
				   p邽߂ɁASCC0݂̂płȂB */
#endif /* GDB_STUB */


/*
 *  VXe^XNɊւ`
 */
#define	LOGTASK_PORTID	1u	/* VXeOo͂VA|[gԍ */

/*
 *  ԑ҂̂߂̒`
 */
#define	SIL_DLY_TIM1	2865
#define	SIL_DLY_TIM2	398

/*
 *  ݃}XN̏l (MIPS3RÂ^[QbgVXeˑȂ̂ŁAŒ`)
 */

/*  MIPS3RÅ֌W */
/*  IȊݐ́AO݃Rg[ōs߁AMIPS3RAɊւĂ
    \ȕB*/
/*  RTE-VR5500-CBł2{̊ݐڑĂB */
#define INIT_CORE_IPM	( Cause_Int1 | Cause_Int0 )

/*  O݃Rg[֌W  */
/*  (ݐOɂāA^C}Ô݊݋j */
#define INIT_INT0M	TIMER0
#define INIT_INT1M	0u

#ifndef _MACRO_ONLY

/*
 *  ^[QbgVXeˑ̏
 */
extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgDROMj^ďoŎ邱Ƃz肵
 *  ĂD
 */
extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`DROMj^ďoŎ邱
 *  Ƃz肵ĂD
 */

extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*============================================================================*/
/* ȉ́AʃhLgɖƎ̒` */

/*
 *  Xe[^XWX^̏l
 */
#define INIT_SR		(SR_BEV | INIT_CORE_IPM | SR_DE)
	/*
	 *  BEV = 1FOxN^kseg0ZOgɔzu
	 *  IM = 0FCPUbN (݋֎~)
	 *  DE = 1 : LbVpeBG[ɂŐ֎~
	 */

/*
 *  RtBOWX^lݒp}XN
 */
#define INIT_CONFIG_MASK	0x0

/*
 *  VARg[̃{[[g̐ݒ (ݒf[^G[bps]Ŏw)
 */
#define DEVIDE_RATIO	9600u	/*  9600bpsI  */

#endif /* _SYS_CONFIG_H_ */
