/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"
#include "offset.h"

	.section .text
	.align 2

	.set noat
		/* atWX^𗘗pƂɃ[jOo͂Ȃ悤w */
	.set noreorder

/*
 *  O/荞ݏo[`iʗOj
 *
 *  dlF
 *  ECPUOnh́A^XNReLXgŎsB
 *  Ek0 WX^A݁^OlXgJE^ƂĎgpB
 *  Ereqflg `FbNOɊ݂֎~ȂƁAreqflg `FbNɋN
 *    ꂽ݃nhŃfBXpb`vꂽꍇɃfBXpb`ȂB
 *  E݋^s̏́AEXLrbgpčsB
 *    ́AďõReLXg CPUbNԂۑ邽߂łB
 *    AʕɏڍsꍇɂIErbgpāA݋^s
 *    Kv邽߂ɁAIErbgɂ銄݋^sɕύXĂ
 *    ɒӁB
 *    iFxfBXpb`̏ɓ钼OA^XNOďoOj
 *
 *  Cꃋ[`long long^gꍇ̓WX^̑Ҕ^double wordōs
 *  ׂAgppxႢ̂ƁAõI[o[wbhlāAwordő
 *  ^sĂBIɂ͑Ҕf[^TCY^XNŎwł
 *  悤ɂ\
 */

	.global general_exception
	.global join_interrupt_and_exception
		/* ֐ďo(proc_interrupt_sys)ɕKv */

general_exception:
	addi    sp, sp, -25*4
	sw      sp,  0*4(sp)		/* EXCSTACK\̗p(cpu_experr֐p) */
	sw      at,  1*4(sp)
	sw      v0,  2*4(sp)
	sw      v1,  3*4(sp)
	sw      a0,  4*4(sp)
	sw      a1,  5*4(sp)
	sw      a2,  6*4(sp)
	sw      a3,  7*4(sp)
	sw      t0,  8*4(sp)
	sw      t1,  9*4(sp)
	sw      t2, 10*4(sp)
	sw      t3, 11*4(sp)
	sw      t4, 12*4(sp)
	sw      t5, 13*4(sp)
	sw      t6, 14*4(sp)
	sw      t7, 15*4(sp)
	sw      t8, 16*4(sp)
	sw      t9, 17*4(sp)
	sw      gp, 18*4(sp)
	sw      fp, 19*4(sp)
	sw      ra, 20*4(sp)

	mfc0    a1, Status		/* a1 -> OŎg */
	mfc0    t1, EPC

	sw      a1, 21*4(sp)		/* Status */
	sw      t1, 22*4(sp)		/* EPC */

	mfhi    t2			/* 揜ZWX^ HI ̑Ҕ */
	mflo    t3			/* 揜ZWX^ LO ̑Ҕ */

	sw      t2, 23*4(sp)		/* HI */
	sw      t3, 24*4(sp)		/* LO */

	move	a0, sp			/* Onḧݒ */
		/* ́AÕf[^ޔX^bN̈ւ̃|C^
		   ݃Rg[̃f[^܂߂ƕGɂȂ邽߁A
		   ΏۂMIPS3RÃWX^݂̂ƂB */

	PUSH_ICU_IPM			/* ݃Rg[̊݃}XN
					   Ҕ}N(VXeˑŒ`) */

	bgtz    k0, multipul_exception  /*  i̗OƑdO̔ */
	addi    k0, k0, 1               /* lXgJE^̃CNg */

/* i̗Ȍꍇ */
first_exception:
	la      t3, _stack_top		/* _stack_top ́AVXeˑ
					   (JXNvg)` */
					/* X^bN|C^̌Z(t3=t3-4)́A
					   _stack_top ݒ莞ɍsĂ̂ŁA
					   ł͕sv */
	sw      sp, (t3)		/* ^XNX^bN|C^̕ۑ */
	move    sp, t3			/* X^bN؂ւ */

	jal     proc_interrupt_and_exception	/* ݂ƗO̔ʏ */
	nop

	/*  ݋֎~Ŗ߂Ă  */
	la      t2, reqflg
	lw      t3, (t2)		/* t3 = reqflg */
	lw      sp, (sp)		/* X^bN؂ւ */
	beq     t3, zero, ret_to_task_int	/* fBXpb`vȂꍇ */
	nop

	j       ret_int			/* ݁^Ȍo */
	sw      zero, (t2)		/* reqflg ̃NA */

/* dOid݁j̏ꍇ (Onḧ͊ a0 ɐݒς) */
multipul_exception:
	jal     proc_interrupt_and_exception	/* ݂ƗO̔ʏ */
	nop

/* fBXpb`Ă΂ɒPɊ݌iOjɖ߂ꍇ */
ret_to_task_int:
	POP_ICU_IPM			/* ݃Rg[̊݃}XN
					   A}N(VXeˑŒ`) */

	lw      t0, 23*4(sp)		/* HI */
	lw      t1, 24*4(sp)		/* LO */

	mthi    t0			/* 揜ZWX^ HI ̕ */
	mtlo    t1			/* 揜ZWX^ LO ̕ */

/*  ۗFlong long^gpꍇ  */
	lw      t0, 21*4(sp)    	/* Status */
	lw      t1, 22*4(sp)		/* EPC */

	lw      at,  1*4(sp)
	lw      v0,  2*4(sp)
	lw      v1,  3*4(sp)
	lw      a0,  4*4(sp)
	lw      a1,  5*4(sp)
	lw      a2,  6*4(sp)
	lw      a3,  7*4(sp)

	/*
	 *  dOȂ̂ŁA^XNXCb`ȂꍇȂ̂ŁA^XNReLXg
	 *  ̊݃}XNύXĂSz͂ȂB
	 *  iXe[^XWX^͌̒l̂܂܏߂j
	 */
	mtc0    t0, Status
	mtc0    t1, EPC

	lw      t0,  8*4(sp)
	lw      t1,  9*4(sp)
	lw      t2, 10*4(sp)
	lw      t3, 11*4(sp)
	lw      t4, 12*4(sp)
	lw      t5, 13*4(sp)
	lw      t6, 14*4(sp)
	lw      t7, 15*4(sp)
	lw      t8, 16*4(sp)
	lw      t9, 17*4(sp)
	lw      gp, 18*4(sp)
	lw      fp, 19*4(sp)
	lw      ra, 20*4(sp)

	addi    sp, sp, 25*4		/* ERET ߂́A̖߂sȂ
					   ̂ŒxXbgɂ͓ȂB*/

	eret				/* O̕A */
	nop

/*
 *  ݂ƗO̔ʏ֐
 *    ȉ̃WX^ɒlς
 *      a0 : Onḧ, a1 : Xe[^XWX^
 */
proc_interrupt_and_exception:
	addi    sp, sp, -4
	sw      ra, 0(sp)

	mfc0    a2, Cause
	andi    t2, a2, ExcCode_mask
	beq     t2, zero, proc_interrupt        /* ݂ƗO̔ */
		/* 璼proc_interrupt_sys֔тA͂Ȃ
		   \̂ŁAxproc_interruptɔԁB */
	nop

/* ݈ȊO̗Ȍ */
	la      t4, exc_table
         	              		/* a1 = Status  */
	ori     t5, a1, SR_EXL
	xori    t5, t5, SR_EXL		/* EXLrbgNA */
		/* ݈ȊO̗OCPUbNԂł󂯕t̂ŁACPUbN
		   ԂۑKvB̂IErbg͑삹ɁA
		   ݋֎~EEXLrbgpĎ */
	add     t6, t4, t2		/* OR[hΉAhX̐ݒ */
	lw      t7, (t6)		/* Cꃋ[`̌ďoAhX擾 */
	jalr    t7			/* Cꃋ[`Ăяo */
	mtc0    t5, Status		/* ݋ (EXLrbg = 0) */

	mfc0    t0, Status
	ori     t0, t0, SR_EXL
	mtc0    t0, Status              /* ݋֎~ (EXLrbg = 1) */

	NOP_FOR_CP0_HAZARD		/* CP0nU[ĥ߂̎ԉ҂}N
					   (̃}N̓VXeˑ`) */

	j       join_interrupt_and_exception	/* OE݂̍n_ */
	nop

/* ݂̏ꍇ̏ */
proc_interrupt:

/*
 *  ݃Rg[̑lɑΉ邽߁A̓VXeˑōsB
 *    @́A
 *	}NiPROC_INTERRUPT_SYSj܂́A֐ďo(proc_interrupt_sys)
 *    ƂB
 *
 *  EďoɃZbgĂ
 *	a1 : Xe[^XWX^
 *	a2 : WX^
 *
 *  Eɂ́AraWX^j󂵂Ă͂ȂȂB
 *
 *  E̓Iȏ̗F
 *	1. ݗv̔
 *	2. ݃}XNiRAA݃Rg[j̐ݒ
 *	3. ݋
 *	4. bꃋ[`̌ďo
 *	5. ݋֎~
 *	6. ݃Rg[̊ݗṽNA
 *     (7. join_interrupt_and_exceptionɖ߂B; ֐ďȍꍇ)
 */

#ifdef PROC_INTERRUPT_SYS
	PROC_INTERRUPT_SYS
#else /* PROC_INTERRUPT_SYS */
	j	proc_interrupt_sys
	nop
#endif /* PROC_INTERRUPT_SYS */

/* OEݏ̍n_ */
join_interrupt_and_exception:
	addi	k0, k0, -1		/* lXgJE^ fBNg */
	lw      ra, (sp)		/* ra 𕜌 */
	jr      ra			/* proc_interrupt_and_exeption ̌ďo
					   ɖ߂ */
	addi    sp, sp, 4

/*
 *  荞݃nh/CPUOnho
 *
 *  ߂悪^XNReLXgreqflgZbgĂꍇ̂݁AɂB
 *  Ek0 = 0A݋֎~ԁAėpWX^ۑԂŌĂяoƁB
 *  Et1runtsk̒lĂret_int_1ɃWv邱ƁB
 */

ret_int:
	POP_ICU_IPM			/* ݃Rg[̊݃}XN
					   A}N(VXeˑŒ`) */

	lw      t1, 21*4(sp)		/* Status */
	ori	t1, t1, SR_EXL		/* ݏɓƂ́ACPUbN
					   Ԃێ̂ŁA݋֎~
					   EXLrbgpčsB */
	mtc0    t1, Status		/* MIPS3RÅ݃}XN̕A
					    + EXLrbgɂ銄݋֎~ */

	la      t0, enadsp
	la      t3, runtsk
	lw      t2, (t0)		/* t2 = enadsp */
	lw      t1, (t3)		/* t1 = runtsk */
 	beq     t2, zero, ret_int_1	/* fBXpb`֎~ȂWv */
	nop
	la      t4, schedtsk
	lw      t5, (t4)		/* t5 = schedtsk */
	beq     t1, t5, ret_int_1	/* runtsk = schedtsk ȂWv */
	nop

/* fBXpb`oRꍇ̏ (t1 = runtsk ɒ) */
	/* A݋֎~^AEXLrbgpĎ@ɕύX */
	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE
	xori	t0, t0, SR_EXL_IE	/* lock_cpu  (݋֎~)
					    + EXLrbgNA (݋) */
	mtc0	t0, Status

	addi    sp, sp, -8*4		/* XNb`WX^̕ۑ */
	sw      s0, 0*4(sp)
	sw      s1, 1*4(sp)
	sw      s2, 2*4(sp)
	sw      s3, 3*4(sp)
	sw      s4, 4*4(sp)
	sw      s5, 5*4(sp)
	sw      s6, 6*4(sp)
	sw      s7, 7*4(sp)
					/* t1 = runtsk ɒ  */
	sw      sp, TCB_sp(t1)		/* runtsk->sp = sp
					   (^XNX^bN|C^̕ۑ) */
	la      t2, ret_int_r

	j       dispatcher		/* fBXpb`Ăяo */
	sw      t2, TCB_pc(t1)		/* runtsk->pc = ret_int_r
					   (sĊJԒn̕ۑ) */

/*
 * ݁EȌo
 *   EfBXpb`ɂāAt1 = runtsk ƂȂĂ邱Ƃɒ
 *   EX^bN|C^ݒς
 */
/* fBXpb`Ăяõ^XNReLXg̍n_ */
ret_int_r:
	lw      s0, 0*4(sp)		/* XNb`WX^̕ */
	lw      s1, 1*4(sp)
	lw      s2, 2*4(sp)
	lw      s3, 3*4(sp)
 	lw      s4, 4*4(sp)
	lw      s5, 5*4(sp)
	lw      s6, 6*4(sp)
	lw      s7, 7*4(sp)
	addi    sp, sp, 8*4

	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE	/* unlock_cpu  (݋)
					    + EXLrbgZbg (݋֎~) */
	mtc0	t0, Status

/* fBXpb`oRȂꍇ̍n_ (t1 = runtsk ɒ) */
ret_int_1:

	/* ^XNOṽ`FbN */
	lb      t2, TCB_enatex(t1)
	andi    t4, t2, TCB_enatex_mask /* t3 = runtsk->enatex  */
	beq     t4, zero, ret_int_2     /* ^XNO֎~̎AWv */
	nop

	lw      t5, TCB_texptn(t1)      /* t5 = runtsk->texptn */
	beq     t5, zero, ret_int_2	/* ^XNOvAWv */
	nop

	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE
	xori	t0, t0, SR_EXL_IE	/* lock_cpu (݋֎~)
					    + EXLrbgNA (݋) */
	mtc0	t0, Status

	jal     call_texrtn             /* ^XNO[`(^[Qbg
					   ˑ`)̌Ăяo */
	nop
		/* call_texrtn()(task.c)ł́Aۂ̃^XNO[`Ă
		   oOŁAunlock_cpuAlock_cpusĂ̂ŁAԂ
		   ێB */

	mfc0	t0, Status
	ori	t0, t0, SR_EXL_IE	/* unlock_cpu  (݋)
					    + EXLrbgZbg (݋֎~) */
	mtc0	t0, Status
	/* ܂łA݋֎~^AEXLrbgpĎ@ */

ret_int_2:
	/* WX^̕A (StatusWX^́Aɕς) */
	lw      t1, 22*4(sp)		/* EPC */
	mtc0    t1, EPC

	lw      t2, 23*4(sp)		/* HI */
	lw      t3, 24*4(sp)		/* LO */

	mthi    t2			/* 揜ZWX^ HI ̕ */
	mtlo    t3			/* 揜ZWX^ LO ̕ */

	lw      at,  1*4(sp)
	lw      v0,  2*4(sp)
	lw      v1,  3*4(sp)
	lw      a0,  4*4(sp)
	lw      a1,  5*4(sp)
	lw      a2,  6*4(sp)
	lw      a3,  7*4(sp)
	lw      t0,  8*4(sp)
	lw      t1,  9*4(sp)
	lw      t2, 10*4(sp)
	lw      t3, 11*4(sp)
	lw      t4, 12*4(sp)
	lw      t5, 13*4(sp)
	lw      t6, 14*4(sp)
	lw      t7, 15*4(sp)
	lw      t8, 16*4(sp)
	lw      t9, 17*4(sp)

	lw      gp, 18*4(sp)
	lw      fp, 19*4(sp)
	lw      ra, 20*4(sp)

	addi    sp, sp, 25*4

	eret				/* /O̕A */
	nop

/*
 *  ^XNfBXpb`
 *  Edispatch ́Ak0 = 0ACPUbN(݋֎~)ԂŌĂяoȂ΂ȂȂB
 *  Eexit_and_dispatch ́Ck0 = 0ACPUbN(݋֎~)ԂŌĂяô
 *    AJ[lN̂߁Ck0 = 1ŌĂяoꍇɂΉĂB
 */

	.global dispatch
	.global exit_and_dispatch

/* ^XNfBXpb`𖾎IɌĂяo */
dispatch:
	addi    sp, sp, -13*4
	sw      at,  1*4(sp)		/* XNb`WX^̑Ҕ */
	sw      s0,  2*4(sp)
	sw      s1,  3*4(sp)
	sw      s2,  4*4(sp)
	sw      s3,  5*4(sp)
	sw      s4,  6*4(sp)
	sw      s5,  7*4(sp)
	sw      s6,  8*4(sp)
	sw      s7,  9*4(sp)
	sw      gp, 10*4(sp)
	sw      fp, 11*4(sp)
	sw      ra, 12*4(sp)

	la      t0, runtsk
	la      t2, dispatch_r
	lw      t1, (t0)		/* t1 = runtsk */
	sw      sp, TCB_sp(t1)		/* runtsk->sp = sp */
	j       dispatcher
	sw      t2, TCB_pc(t1)		/* runtsk->pc = dispatch_r */

/* ݎs̃ReLXĝĂāA^XNfBXpb`Ăяo */
exit_and_dispatch:
	move    k0, zero		/* lXgJE^NA */

dispatcher:
	/* ɂ CPUbNi荞݋֎~jŗ邱 */
	la      t0, schedtsk
	lw      t1, (t0)		/* t1 = schedtsk */
	beq     t1, zero, dispatcher_2	/* schedtsk Ίݑ҂ */
	nop

dispatcher_1:
	la      t0, runtsk
	sw      t1, (t0)		/* runtsk = t1 (= schedtsk)
					   (^XNXCb`̎s) */
	lw      t2, TCB_pc(t1)		/* sĊJԒn擾B
					   sĊJԒn͈ȉ3ʂ
					     EfBXpb`̏o  dispatch_r
					     E݁^Ȍo    ret_int_r
					     E^XNN        activate_r
					   ̏ꍇ t1=runtsk ƂČĂ
					   oĂ邱ƂɒӁB */
	jr      t2			/* sĊJԒnփWv */
	lw      sp, TCB_sp(t1)		/* X^bN|C^𕜌 */

	/*
	 *  sׂ^XN܂ő҂
	 *
	 *  ŃReLXg؂芷̂́C
	 *    EŔ銄ݏɂǂ̃X^bNgƂ̉
	 *    E݃nhł̃^XNfBXpb`̖h~
	 *  Ƃ̈ӖD
	 */ 
dispatcher_2:
	la	t2, runtsk
	sw	zero, (t2)		/* runtsk = NULL
					   ́Aiget_id ATSK_NONEԂ
					   ꍇɑΉ邽߁B*/

	la      sp, _stack_top		/* X^bN؂ւ */
					/* _stack_top ́AVXeˑ
					   (JXNvg)` */
	li      k0, 1			/* lXgJE^1 */

	/* [vŎg萔̏ */
	la      t2, reqflg              /* reqflg ̃AhX */
	li      t3, ~SR_ERL_EXL         /* Status ̊݊֘Arbg */
	li      t4, ~SR_IE              /* Status ̊݋rbg */

dispatcher_3:
	mfc0    t1, Status
	and     t1, t1, t3		/* ERL, EXL rbgNA */
	ori     t1, t1, SR_IE		/* IErbgZbg */
	mtc0    t1, Status		/* ݋ : unlock_cpu  */
	and     t1, t1, t4		/* IErbgZbg */
	mtc0    t1, Status		/* ݋֎~ : lock_cpu  */

	NOP_FOR_CP0_HAZARD		/* CP0nU[ĥ߂̎ԉ҂}N
					   (̃}N̓VXeˑ`) */

	lw      t5, (t2)		/* t5 = reqflg */

	beq     t5, zero, dispatcher_3	/* fBXpb`vȂ΃[v
					   擪 */
	nop
	sw      zero, (t2)		/* reqflg = NULL (reqflgNA) */
	j       dispatcher		/* sĊJԒn̎擾փWv */
	move    k0, zero		/* lXgJE^NA */

/*
 *  fBXpb`o
 *  EfBXpb`ɂāAt1 = runtsk ƂȂĂ邱Ƃɒ
 *  EX^bN|C^ݒς
 */
dispatch_r: 
	lw      at,  1*4(sp)		/* XNb`WX^𕜋A */
	lw      s0,  2*4(sp)
	lw      s1,  3*4(sp)
	lw      s2,  4*4(sp)
	lw      s3,  5*4(sp)
	lw      s4,  6*4(sp)
	lw      s5,  7*4(sp)
	lw      s6,  8*4(sp)
	lw      s7,  9*4(sp)
	lw      gp, 10*4(sp)
	lw      fp, 11*4(sp)
	lw      ra, 12*4(sp)
	addi    sp, sp, 13*4

	/* ^XNOṽ`FbN */
	lb      t2, TCB_enatex(t1)
	andi    t4, t2, TCB_enatex_mask	/* t4 = runtsk->enatex */
	beq     t4, zero, dispatch_r_1	/* ^XNO֎~̎AWv */
	nop

	lw      t5, TCB_texptn(t1)	/* t5 = runtsk->texptn */
	beq     t5, zero, dispatch_r_1	/* ^XNOvAWv */
	nop

	j       call_texrtn		/* ^XNO[`(^[Qbg
					   ˑ`)̌Ăяo */
	nop
		/* call_texrtn()(task.c)ł́Aۂ̃^XNO[`Ă
		   oOŁAunlock_cpuAlock_cpusĂ̂ŁAԂ
		   ێB */

dispatch_r_1:
	jr      ra			/* dispatch Ăяo֖߂ */
	nop

/*
 *  ^XNN
 *  EfBXpb`ɂāAt1 = runtsk ƂȂĂ邱Ƃɒ
 *  EX^bN|C^ݒς
 */

	.globl activate_r

activate_r:
	/* ɗƂ́ACPUbNɂȂĂiIErbg = 0) */

	/* 荞݋̏ */
	mfc0    t0, Status
	ori     t0, t0, SR_ERL_EXL_IE   /* xorg߁A1xrbgZbg */
	xori    t0, t0, SR_ERL_EXL      /* ERL, EXLrbgNA
					   (IErbg͎c)  */

	/* ^XN֌W̐ݒ菀 */
					/* t1 = runtsk (fBXpb`Őݒ) */
	lw      t2, TCB_tinib(t1)       /* t2 = runtsk->tinib */

	/* ^XNNԒn̐ݒ */
	lw      t3, TINIB_task(t2)      /* t3 = runtsk->tinib->task */

	/* ^XNւ̈igjݒ */
	lw      a0, TINIB_exinf(t2)     /* a0 = runtsk->tinib->exinf */

	mtc0    t0, Status              /* unlock_cpu  (݋) */

	la      ra, ext_tsk             /* ^XN̖߂Ԓnݒ */

	j       t3                      /* ^XNN */
	nop
