/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Ryosuke Takeuchi
 *              Platform Development Center RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: serial_mini.c,v 1.1 2008/06/17 00:04:55 suikan Exp $
 */

/*
 *	VAC^tF[XhCo
 */

#include <t_services.h>
#include <serial.h>
#include <hw_serial.h>
#include "kernel_id.h"

/*
 *  VA|[gǗubN̒`
 */

#define	SERIAL_BUFSZ	9	/* VAC^tF[Xpobt@̃TCY */

typedef struct serial_queue_block {
	BOOL openflag;				/* I[vς݃tO */
	UH   base;					/* hardware port base address */
	ID   rsemid;				/* receive semaphore id */
	ID   ssemid;				/* send semaphore id */
	char head;					/* queue head */
	char tail;					/* queue tail */
	char size;					/* obt@TCY */
	char buffer[SERIAL_BUFSZ];	/* obt@GA */
} SQUE;

static SQUE	in_queue[TNUM_SIOP] ={
	FALSE, TADR_SFR_UART0_BASE, SERIAL_RCV_SEM1, SERIAL_SND_SEM1, 0, 0, SERIAL_BUFSZ, "",
	FALSE, TADR_SFR_UART1_BASE, SERIAL_RCV_SEM2, SERIAL_SND_SEM2, 0, 0, SERIAL_BUFSZ, ""
};

/*
 *  VA|[gǗubN̒`Ə
 */

#define get_sque(portid)	(&(in_queue[portid-1]))

/*
 *  SFR UART̏
 */
Inline void
SFR_uart_initialize(ID portid)
{
	SQUE  *q;
	VB *ip = (VB*)(TADR_SFR_INT_BASE+TADR_SFR_S0RIC_OFFSET);

	q = get_sque(portid);
	  			/* M[hWX^̏ */
	sil_wrb_mem((VP)(q->base+TADR_SFR_UMR_OFFSET), MR_DEF);
				/* M䃌WX^̏ */
	sil_wrb_mem((VP)(q->base+TADR_SFR_UC0_OFFSET), C0_DEF);
				/* ]xWX^̏ */
	sil_wrb_mem((VP)(q->base+TADR_SFR_UBRG_OFFSET), BRG1_DEF);
				/* ݃x̐ݒ */
	set_ic_ilvl((VP)(ip + ((INT)portid-1)*2), RB_LEVEL);
	sil_wrb_mem((VP)(q->base+TADR_SFR_UC1_OFFSET), C1R_DEF);
	sil_reb_mem((VP)(q->base+TADR_SFR_URB_OFFSET));		/* _~[f[^M */
	sil_reb_mem((VP)(q->base+TADR_SFR_URB_OFFSET));		/* _~[f[^M */
	q->openflag = TRUE;
}

/*
 *  SQUE̎Mobt@TCYo
 */
Inline int
queue_size(SQUE *q)
{
	int size = q->head - q->tail;
	if(size < 0)
		size += q->size;
	return size;
}

/*
 *  VAC^tF[XhCőN
 */
void
serial_initialize(VP_INT exinf)
{
	SFR_uart_initialize(LOGTASK_PORTID);
}

/*
 *  VA|[g̃I[v
 */
ER
serial_opn_por(ID portid)
{
	SQUE  *q;
	VB    *ip=(VB*)(TADR_SFR_INT_BASE+TADR_SFR_S0RIC_OFFSET);
	ER	ercd;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* |[gԍ̃`FbN */
	}
	q = get_sque(portid);

	_syscall(loc_cpu());
	if (q->openflag) {		/* I[vς݂̃`FbN */
		ercd = E_OBJ;
	}
	else {
		SFR_uart_initialize(portid);
		ercd = E_OK;
	}
	_syscall(unl_cpu());
	return(ercd);
}

/*
 *  VA|[g̃N[Y
 */
ER
serial_cls_por(ID portid)
{
	SQUE  *q;
	VB    *ip=(VB*)(TADR_SFR_INT_BASE+TADR_SFR_S0RIC_OFFSET);
	ER	ercd;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* |[gԍ̃`FbN */
	}
	q = get_sque(portid);

	_syscall(loc_cpu());
	if (!(q->openflag)) {	/* I[vς݂̃`FbN */
		ercd = E_OBJ;
	}
	else {
		set_ic_ilvl((VP)(ip + ((INT)portid-1)*2), 0);
		sil_wrb_mem((VP)(q->base+TADR_SFR_UC1_OFFSET), C1S_DEF);
		q->openflag = FALSE;
		ercd = E_OK;
	}
	_syscall(unl_cpu());
	return(ercd);
}

/*
 *  VA|[gւ̑M
 */

ER_UINT
serial_wri_dat(ID portid, char *buf, UINT len)
{
	SQUE	*q;
	unsigned int	i;
	unsigned char   c;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* |[gԍ̃`FbN */
	}

	q = get_sque(portid);
	if (!(q->openflag)) {	/* I[vς݂̃`FbN */
		return(E_OBJ);
	}

	wai_sem(q->ssemid);
	for (i = 0; i < len; i++) {
		while((sil_reb_mem((VP)(q->base+TADR_SFR_UC1_OFFSET)) & 0x2) == 0);
		sil_wrb_mem((VP)(q->base+TADR_SFR_UTB_OFFSET), *buf++);
	}
	sig_sem(q->ssemid);
	return(len);
}

/*
 *  VA|[g̎M
 */

ER_UINT
serial_rea_dat(ID portid, char *buf, UINT len)
{
	SQUE	*q;
	UINT	i;

	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* |[gԍ̃`FbN */
	}

	q = get_sque(portid);
	if (!(q->openflag)) {	/* I[vς݂̃`FbN */
		return(E_OBJ);
	}

	for (i = 0; i < len; i++) {
		if (queue_size(q) == 0)
			wai_sem(q->rsemid);
		else
			pol_sem(q->rsemid);
		_syscall(loc_cpu());
		*buf++ = q->buffer[q->tail++];
		if (q->tail >= q->size) {
			q->tail = 0;
		}
		_syscall(unl_cpu());
	}
	return(len);
}

/*
 *  VA|[g̐
 */
ER
serial_ctl_por(ID portid, UINT ioctl)
{
	return(E_OK);
}

/*
 *  VA|[gԂ̎Q
 */
ER
serial_ref_por(ID portid, T_SERIAL_RPOR *pk_rpor)
{
	SQUE	*q;

	if (sns_ctx()) {		/* ReLXg̃`FbN */
		return(E_CTX);
	}
	if (!(1 <= portid && portid <= TNUM_SIOP)) {
		return(E_ID);		/* |[gԍ̃`FbN */
	}

	q = get_sque(portid);
	if (!(q->openflag)) {	/* I[vς݂̃`FbN */
		return(E_OBJ);
	}

	pk_rpor->reacnt = queue_size(q);
	pk_rpor->wricnt = 0;
	return(E_OK);
}

/*
 *  VA|[g݃T[rX[`
 */

void
serial_handler_in(ID portid)
{
	SQUE	*q;
	int		rdata;				/* Mobt@ */

	q = get_sque(portid);
	if (queue_size(q) < q->size) {
		rdata = sil_reb_mem((VP)(q->base+TADR_SFR_URB_OFFSET));	/* f[^M */
		q->buffer[q->head++] = rdata;
		if (q->head >= q->size)
			q->head = 0;
		isig_sem(q->rsemid);
	}
}

/*
 *  ݃nh
 */

void
serial_in_handler1(void)
{
	serial_handler_in(1);
}

void
serial_in_handler2(void)
{
	serial_handler_in(2);
}

