/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _UTIL_H_
#define _UTIL_H_

/*
 *  ̃wb_t@CɊ܂܂Ă}ŃAƂāAJ[lJ҂ɑ΂
 *  JĂ̂łB̂߁Ap[^`FbNȂǂs\łB
 *  [U[ɂẮAȐӔCɂėp邱ƁB
 */

/*
 *  rbgԍ̒`
 */
#define BIT0              0x1
#define BIT1              0x2
#define BIT2              0x4
#define BIT3              0x8
#define BIT4             0x10
#define BIT5             0x20
#define BIT6             0x40
#define BIT7             0x80
#define BIT8            0x100
#define BIT9            0x200
#define BIT10           0x400
#define BIT11           0x800
#define BIT12          0x1000
#define BIT13          0x2000
#define BIT14          0x4000
#define BIT15          0x8000

#define DUMMY		    0

/*
 *  oCgf[^p}N
 */
/* ȉɂāAxFs */

/* ȉ̂悤ȏƁAǂǂH
     (UH) (((UW) (c)) & 0x0000ffff)
     (UH) (((UW) (c)) & 0xffff0000) >> 16
*/

/* (UH) xxaa -> (UB) aa */			/* 1oCgo */
#define LO8(c)		(UB)( (UH)(c) & 0xff )
/* (UH) aaxx -> (UB) aa */			/* 1oCgo */
#define HI8(c)		LO8( (UH)(c) >>  8 )

/* (UW) xxxxaaaa -> (UH) aaaa */		/* 2oCgo */
#define LO16(c)		(UH)( (UW)(c) & 0xffff )
/* (UW) aaaaxxxx -> (UH) aaaa */		/* 2oCgo */
#define HI16(c)		LO16( (UW)(c) >> 16 )

/* (UH) aaaa, (UH) bbbb -> (UW) aaaabbbb */	/* 2oCgf[^̌ */
#define JOIN16(hi, lo)	(UW)( ((UW)(hi) << 16) | (lo) )
/* (UB) aa, (UB) bb -> (UH) aabb */		/* 1oCgf[^̌ */
#define JOIN8(hi, lo)	(UH)( ((UH)(hi) <<  8) | (lo) )

/* (BIN) : Qi */
/* (BIN) xxxxaaaa -> (BIN) 0000aaaa */		/* 0-3rbgɔzu  */
#define TO_LO4(c)	( (UB)(c) & 0xf )
/* (BIN) xxxxaaaa -> (BIN) aaaa0000 */		/* 4-7rbgɔzu  */
#define TO_HI4(c)	(((UB)(c) << 4) & 0xf0)

/*
 *  V{̌
 */
#define JOINT(a,b)      _JOINT(a,b)
#define _JOINT(a,b)     a##b

#define JOINT3(a,b,c)   _JOINT3(a,b,c)
#define _JOINT3(a,b,c)  JOINT(a,JOINT(b,c))

#define JOINT4(a,b,c,d)   _JOINT4(a,b,c,d)
#define _JOINT4(a,b,c,d)  JOINT(a,JOINT3(b,c,d))

#endif /* _UTIL_H_ */
