/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *      vZbTˑW[iH8Spj
 *@@@@@J[lŎgp`
 *@@@@@@f[^^A}NA֐̃vg^Cv錾
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>


/*
 *  vZbT֘A̒`
 */
#include <h8s.h>
#include <h8s_sil.h>


/*
 *  vZbT̓ꖽ߂̃CC֐`
 *    ŁAMAX_IPM𗘗pĂ̂ŁA`ɓǂݍ
 */
#include <cpu_insn.h>

/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define TBIT_TCB_TSTAT          8       /* tstat tB[h̃rbg */
#define TBIT_TCB_PRIORITY       8       /* priority tB[h̃rbg */

/*
 *  ^XNReLXgubN̒`
 */
#ifndef _MACRO_ONLY

typedef struct task_context_block {
	VP	sp;		/* X^bN|C^ */
	FP	pc;		/* vOJE^ */
} CTXB;

#endif /* _MACRO_ONLY */

/*
 *  VXeԎQ
 */
#ifndef _MACRO_ONLY

/*
 *  ݃lXgJE^
 *    lXgJE^̒lŃReLXg̔fŝŁAReLXgQƎ
 *    pB
 */

extern volatile UB	intnest;

/*
 *  ReLXgQ
 *    ݃lXgJE^ǂݏoɊ݂ĂA߂Ƃɂ
 *    ReLXgɖ߂Ă
 */

Inline BOOL
sense_context(void)
{
	BOOL ret;
	
	ret = (intnest != 0) ? TRUE : FALSE;
	return(ret);
}

/*
 *  CPUbNԂ̎Q
 */

/*
 *  CPUbNԂ\tO
 *  @E݋֎~iJ[lǗ݂̊̂݁j
 *  @@@
 *  @Eiscpulocked == TRUE
 *  @@@̂ƂCPUbNԂƂB
 */
extern volatile BOOL     iscpulocked;

#define sense_lock()    iscpulocked

#endif /* _MACRO_ONLY */

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

#ifndef _MACRO_ONLY

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Achg_ipm T|[g邽߂̕ϐBchg_ipm T|[g
 *  Ȃꍇɂ́At_unlock_cpu  task_intmask  0 ɒuĂ悢B
 */

#ifdef SUPPORT_CHG_IPM
extern volatile IPM	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(void)
{
	disint();		/* cpu_insn.h */
        iscpulocked = TRUE;
}

Inline void
t_unlock_cpu(void)
{
        iscpulocked = FALSE;
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽߁B
	 *  ̓r task_intmask 邱Ƃ͂ȂB
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();		/* cpu_insn.h */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern volatile IPM	int_intmask;	/* ^XNReLXgł̊݃}XN */

Inline void
i_lock_cpu(void)
{
	IPM	intmask;

	/*
	 *  ꎞϐ intmask gĂ̂́Acurrent_intmask()Ă񂾒
	 *  ݂ANꂽ݃nh int_intmask ύX
	 *  \邽߂łB
	 */
	intmask = current_intmask();
	disint();		/* cpu_insn.h */
	int_intmask = intmask;
        iscpulocked = TRUE;
}

Inline void
i_unlock_cpu(void)
{
        iscpulocked = FALSE;
	set_intmask(int_intmask);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.srcj
 *    dispatch ́C^XNReLXgĂяoꂽT[rXR[ŁA
 *    CPUbNԂŌĂяoȂ΂ȂȂB
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.srcj
 *    exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂB
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh̐ݒ
 *    H8Sł́A݃xN^e[uROMɒڂɔzu邽߁A
 *@@ȂB
 *@ixN^e[uperlXNvgŐj
 */

Inline void define_inh(INHNO inhno, FP inthdr) {
}

/*
 *  CPUOnh̐ݒ
 *    H8Sł́ACPUŐ@\Ȃ߁AȂB
 */

Inline void define_exc(EXCNO excno, FP exchdr) {
}

#endif /* _MACRO_ONLY */

/*
 *  ݃nh̏o
 *@@H8CpH8Sˑł݂͊̏oAZu\[X
 *@@邽߁A{CꒆŒ`KvȂB
 *@@ł͋ʕƂ̃C^[tF[X킹邽߁A
 *@@Kvȃ}N`݂̂ĂB
 */

/*
 *  Cꃋ[`̊֐̃x𐶐
 *@@H8CpH8ˑł͓vector.src̃[JEV{
 *@@ł̂ŁAO[oɌJKvȂB
 *@@ł͋ʕƂ̃C^[tF[X킹邽߁A
 *@@_~[̃x^ĂB
 */
#define INT_ENTRY(inthdr) _kernel_common_interrupt_process
#define EXC_ENTRY(exchdr) _kernel_common_interrupt_process

/*
 *  ݃nh̏o̐}N
 *@@@Cł͂܂łȂ߁AAZu\[X
 *@@@ʓrpӂB
 */
#define INTHDR_ENTRY(inthdr) extern void INT_ENTRY(inthdr)(void)

/*
 *  CPUOnh̏o̐}N
 */
#define EXCHDR_ENTRY(exchdr) extern void EXC_ENTRY(exchdr)(void)

/*
 *  CPUO̔̃VXeԂ̎Q
 */
#ifndef _MACRO_ONLY

/*
 *  CPUO̔̃ReLXg
 *    H8Słł́AĂ΂邱Ƃ͖AC^[tF[X낦邽߁A
 *@@ĂB
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
        return(TRUE);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 *    H8Słł́AĂ΂邱Ƃ͖AC^[tF[X낦邽߁A
 *@@ĂB
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return(TRUE);
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY_ */

/*============================================================================*/
/*  ʃhLgɂ͂ȂAƎ̕  */

/*
 *  ݃xݒp}NíACC֐j
 *  Eipr : C^vgvCIeBWX^( IPRA - IPRK ) 16rbg
 *  Emask : IPRݒp}XNiʂʂ̑Ij( IPR_UPR, IPR_LOW )
 *  Elevel : ݃x( 0 - 7 )
 */
#ifndef _MACRO_ONLY

Inline void icu_set_ilv( UH ipr, BOOL mask, INT level ) {
	UB val;
	
	if( mask == IPR_UPR ) {
		val = (UB)(( h8s_reb_reg( ipr ) & ~IPR_UPR_MASK ) | TO_HI4((UB) level));
		h8s_wrb_reg( ipr, val );
	} else if( mask == IPR_LOW ) {
		val = (UB)(( h8s_reb_reg( ipr ) & ~IPR_LOW_MASK ) | TO_LO4((UB) level));
		h8s_wrb_reg( ipr, val );
	}
}

/*
 *  `ݔ̃G[o (cpu_config.c, cpu_support.src)
 */

/*
 * X^bN̐擪eWX^̂܂ł̃ItZbg
 * 
 * @O
 * @@EAhoXh[h
 * @@Eݐ䃂[hQ
 * 
 * @X^bN\
 *@@ +0:er0
 *@@ +4:er1
 *@@ +8:er2
 *@@+12:er3
 *@@+16:er4
 *@@+20:er5
 *@@+24:er6
 *@@+28:exr
 *@@+29:U[u
 *@@+30:crr
 *@@+31:pc
 *@@+34`:ݑOɎgpĂX^bN̈
 */

#ifndef __2000A__
#error support Advanced mode only.(Normal mode isn't supported)
#endif

/*
 * ݔÕX^bN|C^܂ł̃ItZbg
 * @i`ݔj
 */
#define OFFSET_SP	34

/*
 *  `ݔ̃G[õ͎X^bN\̒`
 */
typedef struct exc_stack {
	UW	er0;
	UW	er1;
	UW	er2;
	UW	er3;
	UW	er4;
	UW	er5;
	UW	er6;
	UB	exr;
	UB	dummy;
	UW	pc;	/*  vOEJE^  	*/
} EXCSTACK;


extern void	cpu_experr(EXCSTACK *sp);

#endif /* _MACRO_ONLY_ */

#endif /* _CPU_CONFIG_H_ */
