/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: h8_sil.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  H8SIL̊girbgZj
 *
 *  h8.hɋLq̂GKgAsil.hƂ̃CN[h
 *  Ԃ̊֌WœƗt@CƂ
 *  t_config.h𒼐ڃCN[hƂsil.hɂ
 *  t@CCN[h\B
 *
 *  RpČ^`FbN@\Lɂ邽߁A|C^^
 *  UB *AUH *AUW *pĂB
 *
 */

#ifndef _SIL_H8_H_
#define _SIL_H8_H_

#ifndef _MACRO_ONLY

#include <sil.h>
#include <cpu_insn.h>	/*  bitset(), bitclr()  */

/*
 *  8rbgWX^ANDZ
 */
Inline void
h8_anb_reg(UB *mem, UB data)
{
        UB reg = sil_reb_mem((VP)mem);
        reg &= data;
        sil_wrb_mem((VP)mem, (VB)reg);
}

/*
 *  8rbgWX^ORZ
 */
Inline void
h8_orb_reg(UB *mem, UB data)
{
        UB reg = sil_reb_mem((VP)mem);
        reg |= data;
        sil_wrb_mem((VP)mem, (VB)reg);
}


/*
 *  16rbgWX^ANDZ
 */
Inline void
h8_anh_reg(UH *mem, UH data)
{
        UH reg = sil_reh_mem((VP)mem);
        reg &= data;
        sil_wrh_mem((VP)mem, (VH)reg);
}

/*
 *  16rbgWX^ORZ
 */
Inline void
h8_orh_reg(UH *mem, UH data)
{
        UH reg = sil_reh_mem((VP)mem);
        reg |= data;
        sil_wrh_mem((VP)mem, (VH)reg);
}

/*
 *  32rbgWX^ANDZ
 */
Inline void
h8_anw_reg(UW *mem, UW data)
{
        UW reg = sil_rew_mem((VP)mem);
        reg &= data;
        sil_wrw_mem((VP)mem, (VW)reg);
}

/*
 *  32rbgWX^ORZ
 */
Inline void
h8_orw_reg(UW *mem, UW data)
{
        UW reg = sil_rew_mem((VP)mem);
        reg |= data;
        sil_wrw_mem((VP)mem, (VW)reg);
}

/*
 *  ݃x̐ݒ
 *
 *  @irc  FIRCf[^̐擪AhX
 *
 *  @@UB *iprFݒ肷IPRWX^̔Ԓn
 *  @@UB bit FIPRWX^̊Yrbgԍ
 *  @@IPM ipmFݒ肷銄݃x
 *  @@@@@@@IPM_LEVEL0,IPM_LEVEL1̂ꂩ
 */
Inline void
define_int_plevel(const IRC *irc)
{
        UB *ipr = irc->ipr;
        UB bit = irc->bit;
        IPM ipm = irc->ipm;

        switch(ipm) {
                case IPM_LEVEL0:        /*  vCIeBx0ɐݒ  */
                        bitclr(ipr, bit);
                        break;
                case IPM_LEVEL1:        /*  vCIeBx1ɐݒ  */
                        bitset(ipr, bit);
                        break;
                default:
                        assert(FALSE);
        }
}


/*
 *@I/O|[g̃f[^EfBNVEWX^DDRւ̃ANZX
 *@
 *@@H8DDR͏ݐpłÂ܂܂ł͏]̃rbg
 *@@ύX邱ƂłȂBibset,bclr߂łsj
 *@@̂߁A{ł́AɃe|pӂāADDR
 *@@ݒlێ@̂ĂB
 */
extern UB sil_reb_ddr(UINT port) throw();
extern void sil_wrb_ddr(UINT port, UB data) throw();
extern void sil_anb_ddr(UINT port, UB data) throw();
extern void sil_orb_ddr(UINT port, UB data) throw();

/*
 *@DDR̔ԍ`
 *@
 *@@z̃CfbNXɗpB
 *@@ȂA|[g7͓͐pDDRWX^Ȃ߁AȗĂB
 */
enum IO_PORT {
	IO_PORT1,
	IO_PORT2,
	IO_PORT3,
	IO_PORT4,
	IO_PORT5,
	IO_PORT6,
	IO_PORT8,
	IO_PORT9,
	IO_PORTA,
	IO_PORTB
};

#endif /* _MACRO_ONLY */
#endif  /*  _SIL_H8_H_  */
