/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Katsuhiro Amano
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

#include <hw_serial.h>

/*
 *  vZbTˑW[iH8pj
 */

#ifdef SUPPORT_CHG_IPM
/*
 *  ^XNReLXgł̊݃}XN
 */
volatile UB task_intmask = 0;
#endif /* SUPPORT_CHG_IPM */

/*
 *  ^XNReLXgł̊݃}XN
 */

volatile UB int_intmask = 0;

/*
 *  ݃lXgJE^
 */

volatile UB intnest = 0;

/*
 *  CPUbNԂ\tO
 *@@TRUE FCPUbN
 *@@FALSEFCPUbN
 */
volatile BOOL iscpulocked = TRUE;

/*
 *  ^C}̃vCIeBxݒp̃f[^
 *      {hw_timer.hɋLqׂA
 *      hw_timer.hCN[ht@CłׂĎ̉
 *@@@̈LĂ܂߁Â͂ɋLqB
 */
const IRC TIMER_IRC = {(UB*)SYSTEM_TIMER_IPR,
                        SYSTEM_TIMER_IP_BIT,
                        SYSTEM_TIMER_IPM
                      };

/*
 *  xN^e[ȕifor RedBootj
 */
#ifdef REDBOOT

/*  VECTOR_TABLE_ADDRsys_config.hŒ`  */
extern void	vector(void);

static void
copy_vector_table(void)
{
	UW n;
	UW *dst = (UW *)VECTOR_TABLE_ADDR;	/* xN^e[uRs[ */
	UW *src = (UW *)vector;			/* xN^e[uRs[ */
	TMP_VECTOR tmp_vector;

	load_vector(&tmp_vector);
	for (n = 0; n < VECTOR_SIZE; n++) {
		*dst = JMP_OPECODE | (*src);	/* jmp߂̕t */
		++dst;
		++src;
	}
	save_vector(&tmp_vector);
}
#endif	/* of #ifdef REDBOOT */

/*
 *  vZbTˑ̏
 */

#ifndef H8IPRA_INI
#define H8IPRA_INI	0
#endif  /*  H8IPRA_INI  */

#ifndef H8IPRB_INI
#define H8IPRB_INI	0
#endif  /*  H8IPRB_INI  */

void
cpu_initialize(void)
{
	/* 
	 *@CCR UIrbg荞݃}XNrbgƂĎgpB
	 *@@SYSCR.UE0
	 */
	bitclr((UB*)H8SYSCR, H8SYSCR_UE_BIT);
	
	/* 
	 *@ׂĂ̊݃vCIeBxOɂ
	 *
	 *@@Ej^X^u݂gpꍇ
	 *@@@@H8IPRA_INIH8IPRB_INI`āAݒeێB
	 *@@@@IERWX^̓J[lŕύXĂȂ̂ŁÂ܂܂
	 *@@@@悢B
	 */
	sil_wrb_mem((VP)H8IPRA, H8IPRA_INI);
	sil_wrb_mem((VP)H8IPRB, H8IPRB_INI);
	
	SCI_initialize(SYSTEM_PORTID);

#ifdef REDBOOT
	copy_vector_table();
#endif	/* of #ifdef REDBOOT */
}

/*
 *  vZbTˑ̏I
 */

void
cpu_terminate(void)
{
}

#ifdef SUPPORT_CHG_IPM
/*
 *  ݃}XN̕ύX
 *
 *@IPMɐݒłlƂIPM_LEVEL0AIPM_LEVEL1AIPM_LEVEL2}N
 *@`ĂB
 *
 *
 *@IPM_LEVEL0FxO@ׂĂ݂̊󂯕t
 *@IPM_LEVEL1FxP@NMIуvCIeBxP݂݂̊̂
 *@@@@@@@@@@@@󂯕t
 *@IPM_LEVEL2FxQ@NMIȊO݂̊󂯕tȂ
 *
 *  IPM x0ȊO̎ɂC^XNfBXpb`͕ۗȂDIPM ́C
 *  ^XNfBXpb`ɂāCVsԂɂȂ^XNֈp
 *  D̂߁C^XNsɁCʂ̃^XNɂ IPM ύX
 *  ꍇDJSPJ[lł́CIPM ̕ύX̓^XNO[`
 *  ɂĂN̂ŁCʂ̃^XNɂ IPM ύX邱Ƃ
 *  āCȂ󋵂͏ȂƎvDIPM ̒lɂă^
 *  XNfBXpb`֎~ꍇɂ́Cdis_dsp 𕹗p΂悢D
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
        ER      ercd = E_OK;

        LOG_CHG_IPM_ENTER(ipm);
        CHECK_TSKCTX_UNL();
        CHECK_PAR( (ipm == IPM_LEVEL0) || (ipm == IPM_LEVEL1) || (ipm == IPM_LEVEL2) );

        t_lock_cpu();
        task_intmask = ipm;
        t_unlock_cpu();
        
    exit:
        LOG_CHG_IPM_LEAVE(ercd)
        return(ercd);
}

/*
 *  ݃}XN̎Q
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
        ER      ercd = E_OK;

        LOG_GET_IPM_ENTER(p_ipm);
        CHECK_TSKCTX_UNL();

        t_lock_cpu();
        *p_ipm = task_intmask;
        t_unlock_cpu();

    exit:
        LOG_GET_IPM_LEAVE(ercd, *p_ipm);
        return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*****ȉAʕƂ̃C^[tF[XɊ܂܂Ȃ*********/

/*
 * `ݔ̃G[o
 * @@o^ĂȂ݂ƌĂяo
 * 
 * @X^bN\
 *@@ +0:er0
 *@@ +4:er1
 *@@ +8:er2
 *@@+12:er3
 *@@+16:er4
 *@@+20:er5
 *@@+24:er6
 *@@+28:crr
 *@@+29:pc
 *@@+32`:ݑOɎgpĂX^bN̈
 */

/*
 * ݔÕX^bN|C^܂ł̃ItZbg
 */
#define OFFSET_SP	32u

void cpu_experr(EXCSTACK *sp)
{
    UW sp2, pc, ccr, tmp;
    
    sp2 = (UW)sp + OFFSET_SP;
    tmp = sp->pc;
    ccr = (tmp >> 24u) & 0xffu;	/*  1oCg  */
    pc = tmp & 0x00ffffffu;	/*  3oCg  */
    
    syslog(LOG_EMERG, "Unexpected interrupt.");
    syslog(LOG_EMERG, "PC  = 0x%08x SP  = 0x%08x CCR  = 0x%02x",
                       pc, sp2, ccr);
    syslog(LOG_EMERG, "ER0 = 0x%08x ER1 = 0x%08x ER2 = 0x%08x ER3 = 0x%08x",
                       sp->er0, sp->er1, sp->er2, sp->er3);
    syslog(LOG_EMERG, "ER4 = 0x%08x ER5 = 0x%08x ER6 = 0x%08x",
                       sp->er4, sp->er5, sp->er6);
    while(1)
    	;
}

/*
 *   VXeo͐̎w
 */

void
cpu_putc(char c)
{
    if (c == '\n') {
        SCI_wait_putchar(SYSTEM_SCI, '\r');
    }
    SCI_wait_putchar(SYSTEM_SCI, c);
}

/*
 *  local_memcpy
 *
 *    W C Cu memcpy ƓAᐅRs[֐
 *    NɃG[邽߁AOςĂB
 *    ܂ANXNvg̍Ō̍s
 *
 *       PROVIDE(_memcpy = _local_memcpy);
 *
 *    ǉB
 *
 *    eepmov.w߂gIAf[^]́iԁj
 *    ݋֎~ɂȂĂ܂̂ŁAgpĂȂB
 */

void *
local_memcpy (void *out, const void *in, size_t n)
{
    char *o = out;
    const char *i = in;

    while (n > 0) {
        *o = *i;
        ++o;
        ++i;
        --n;
    }
    return out;
}

