/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

/*
 *  ^[QbgˑVAI/OW[iH8pj
 *    E|[g 1{̏ꍇ HWPORT1_ADDRɎw肳ꂽ|[ggpA
 *      2{̏ꍇ́AHWPORT1_ADDR[UpAHWPORT2_ADDRR\[
 *      o͂ƂĎgpB
 *      HWPORTx_ADDR ^[Qbgˑ sys_config.hŎw肷B
 *    Eʕ̃W[ɂāAXON/XOFFt[䂪s
 *      Ă̂ŁAMTxDRxD2{ł悢
 */

#include <s_services.h>
#include <h8_sil.h>

#ifndef _MACRO_ONLY

/*
 *  VA|[g̏ubN
 */
typedef struct sio_port_initialization_block {
        UB      *base;          /* SCI ̃x[XAhX */
        UW      baudrate;       /* {[Cg           */
        IRC     irc;            /* ݃xݒ */
        UB      smr_init;       /* SMR ̐ݒl         */
} SIOPINIB;

/*
 *  VA|[g̐ubN
 */

typedef struct sio_port_control_block {
        const SIOPINIB  *inib;          /* ubN       */
        VP_INT          exinf;          /* g             */
        BOOL            openflag;       /* I[vς݃tO   */
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ǗubNւ̕ϊ
 */
#define INDEX_SIO(sioid)        ((UINT)(sioid) - 1u)

Inline SIOPCB*
get_siopcb(ID sioid)
{
	UINT index = INDEX_SIO(sioid);
	
	assert(index < TNUM_PORT);
	
    return(&(siopcb_table[index]));
}

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND            1u              /* M\R[obN                 */
#define SIO_ERDY_RCV            2u              /* MʒmR[obN                 */

/*
 *  SCI ֐̎Q
 */
extern void     SCI_initialize (ID sioid);      /* SCI ̏                         */
extern void     SCI_cls_por(UB *base);          /* SCI ̃N[Y                       */
extern void     SCI_in_handler(ID sioid);       /* SCI ͊荞݃nh             */
extern void     SCI_out_handler(ID sioid);      /* SCI o͊荞݃nh             */
extern void     SCI_err_handler(ID sioid);      /* SCI ̓G[荞݃nh       */
extern void     SCI_ierdy_snd(VP_INT exinf);    /* VA I/O ̑M\R[obN */
extern void     SCI_ierdy_rcv(VP_INT exinf);    /* VA I/O ̎MʒmR[obN */

/*
 *  SCI x̊֐
 */

/*
 *  SCI ̃I[v
 */
Inline SIOPCB *
SCI_opn_por (ID sioid)
{
        SCI_initialize(sioid);
        return get_siopcb(sioid);
}

/*
 *  SCI_putchar -- M镶̏
 */
Inline void
SCI_putchar(const SIOPCB *p, UB c)
{
        UB *base_addr = p->inib->base;

        sil_wrb_mem((VP)(base_addr + H8TDR), (VB)c);
        bitclr(base_addr + H8SSR, (UB)H8SSR_TDRE_BIT);
}


/*
 *  ჌xo͂ɗpVA|[g
 *  䂷郌WX^Q̐擪AhX
 */
#if SCI_LOW_PORTID == SCI_PORTID1
#define SCI_LOW_BASE			SCI_PORT1_BASE
#else /* SCI_LOW_PORTID == SCI_PORTID1 */
#define SCI_LOW_BASE			SCI_PORT2_BASE
#endif

/*
 *  SCI_putchar_pol -- |[Oɂ჌xo
 */
Inline void
SCI_putchar_pol(UB c)
{
        UB *base = (UB*)SCI_LOW_BASE;
        UB *addr = base + H8SSR;
        UB tdre = 0;

        /* TDREZbg܂ő҂ */
        while (tdre == 0) {
			/*  RpČx}邽߁ALXgĂ  */
			tdre = (UB)((UB)sil_reb_mem((VP)addr) & H8SSR_TDRE);
		}
        sil_wrb_mem((VP)(base + H8TDR), (VB)c);
        bitclr(addr, (UB)H8SSR_TDRE_BIT);
}

/*
 *  SCI_getchar -- M̓ǂݏo
 */
Inline INT
SCI_getchar(const SIOPCB *p)
{
        UB      *base_addr = p->inib->base;
        INT     ch = (UB)sil_reb_mem((VP)(base_addr + H8RDR));
                /* UB ̃LXǵAgh~邽 */

        bitclr(base_addr + H8SSR, (UB)H8SSR_RDRF_BIT);
        return ch;
}

/*
 *  SCI_putready -- M\
 */
Inline BOOL
SCI_putready(const SIOPCB *pcb)
{
        BOOL ret = TRUE;
        UB ssr = sil_reb_mem((VP)(pcb->inib->base + H8SSR));
        
        ssr &= (UB)H8SSR_TDRE;
        if (ssr == 0) {
			ret = FALSE;
		}
        return(ret);
}

/*
 *  SCI_getready -- M\
 */
Inline BOOL
SCI_getready(const SIOPCB *pcb)
{
        BOOL ret = TRUE;
        UB ssr = sil_reb_mem((VP)(pcb->inib->base + H8SSR));

        ssr &= (UB)H8SSR_RDRF;
        if (ssr == 0) {
			ret = FALSE;
		}
        return(ret);
}

/*
 *  M荞ݐ֐
 */
Inline void
SCI_enable_send(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitset(addr, (UB)H8SCR_TIE_BIT);
}

Inline void
SCI_disable_send(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitclr(addr, (UB)H8SCR_TIE_BIT);
}

/*
 *  M荞ݐ֐
 */
Inline void
SCI_enable_recv(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitset(addr, (UB)H8SCR_RIE_BIT);
}

Inline void
SCI_disable_recv(const SIOPCB *p)
{
        UB *addr = p->inib->base + H8SCR;
        bitclr(addr, (UB)H8SCR_RIE_BIT);
}

/*
 *  SIO ֐̎Q
 */
                                /* SCI ̏                         */
extern void     sio_initialize(void);
                                /* VA I/O ̃R[obN  */
extern void     sio_ena_cbr(SIOPCB *pcb, UINT cbrtn);
                                /* VA I/O ̃R[obN֎~  */
extern void     sio_dis_cbr(SIOPCB *pcb, UINT cbrtn);

/*
 *  ֐V~[V}N
 */
                        /* VA I/O ̑M\R[obN      */
#define sio_ierdy_snd(e)        SCI_ierdy_snd(e)
                        /* VA I/O ̎MʒmR[obN      */
#define sio_ierdy_rcv(e)        SCI_ierdy_rcv(e)

/*
 *  SIO x̊֐
 */

extern void sio_in_handler (void);
extern void sio_out_handler (void);

#ifdef H8_CFG_SCI_ERR_HANDLER
extern void sio_err_handler (void);
#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#if TNUM_PORT >= 2u
extern void sio_in2_handler (void);
extern void sio_out2_handler (void);

#ifdef H8_CFG_SCI_ERR_HANDLER
extern void sio_err2_handler (void);
#endif  /* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#endif  /* of #if TNUM_PORT >= 2u */

/*
 *  sio_opn_por -- |[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID sioid, VP_INT exinf)
{
        SIOPCB  *pcb = SCI_opn_por(sioid);

        pcb->exinf    = exinf;
        pcb->openflag = TRUE;
        return pcb;
}

/*
 *  sio_cls_por -- |[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *pcb)
{
        SCI_cls_por(pcb->inib->base);
        pcb->openflag = FALSE;
}

/*
 *  sio_snd_chr -- M
 */
Inline BOOL
sio_snd_chr(const SIOPCB *pcb, char chr)
{
        BOOL ret = FALSE;
        if (SCI_putready(pcb) == TRUE) {
                SCI_putchar(pcb, (UB)chr);
                ret = TRUE;
        }
        return ret;
}

/*
 *  sio_rcv_chr -- M
 */
Inline INT
sio_rcv_chr(const SIOPCB *pcb)
{
        INT ret = 0;
        if (SCI_getready(pcb) == TRUE) {
                ret = SCI_getchar(pcb);
        } else {
                ret = -1;
        }
        return(ret);
}

#endif  /* of #ifndef _MACRO_ONLY */

#endif /* _HW_SERIAL_H_ */
