/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: jsp_common.cpp,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

#include "jsp/jsp_common.h"

#include "base/option.h"

#include <ctime>

#if defined(_MSC_VER) || defined(__BORLANDC__)
#  define  GETLOGINNAME_WINDOWS
#  include <windows.h>
#elif __GNUC__
#  define  GETLOGINNAME_UNIX
#  include <unistd.h>
#endif

using namespace std;

#if 0
namespace {
    string get_loginname(void) throw()
    {
        string result("TOPPERS/JSP KernelConfigurator");

#ifdef GETLOGINNAME_WINDOWS
        char  buffer[1024];
        DWORD sz = 1024;
        ::GetUserName(buffer, &sz);
        result.assign(buffer);
#elif defined(GETLOGINNAME_UNIX)
        result.assign(getlogin());
#endif

        return result;
    }
}
#endif


    //CN[ht@Č`ύX
string ToppersJsp::conv_includefile(string file) throw()
{
    OptionParameter & option = getOptionParameter();
    string result;

        //ilIvVtƂɂ "<...>" `ŏo
    if(option["il"].isValid())
        result = string("<") + file + ">";
    else
        result = string("\"") + file + "\"";

    return result;
}

    //J[l̕ϐ̌`ύX
string ToppersJsp::conv_kernelobject(string obj) throw()
{
    OptionParameter & option = getOptionParameter();
    string result;

    result = obj;

        // TOPPERS/JSP rel 1.3̓J[lϐ̓ _kernel_ 
    if(!option["1.3"].isValid())
        result = string("_kernel_") + obj;

    return result;
}

ToppersJsp::SpecialtyFile::SpecialtyFile(void) throw() : MultipartStream(), RuntimeObject(true)
{}

#if 0
string ToppersJsp::get_agreement(string filename) throw()
{
    const char * base_agreement =
        "/*\n"
        " *  TOPPERS/JSP Kernel\n"
        " *      Toyohashi Open Platform for Embedded Real-Time Systems/\n"
        " *      Just Standard Profile Kernel\n"
        " * \n"
        " *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory\n"
        " *                              Toyohashi Univ. of Technology, JAPAN\n"
        " * \n"
        " *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation \n"
        " *  ɂČ\Ă GNU General Public License  Version 2 ɋL\n"
        " *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA\n"
        " *  ς̂܂ށDȉjgpEEρEĔzziȉC\n"
        " *  pƌĂԁj邱Ƃ𖳏ŋD\n"
        " *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒\n"
        " *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[\n"
        " *      XR[hɊ܂܂Ă邱ƁD\n"
        " *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg\n"
        " *      pł`ōĔzzꍇɂ́CĔzzɔhLgip\n"
        " *      ҃}jAȂǁjɁCL̒쌠\C̗pщL\n"
        " *      ̖ۏ؋Kfڂ邱ƁD\n"
        " *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg\n"
        " *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂\n"
        " *      ƁD\n"
        " *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒\n"
        " *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD\n"
        " *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg\n"
        " *        񍐂邱ƁD\n"
        " *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹\n"
        " *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD\n"
        " * \n"
        " *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂\n"
        " *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\\n"
        " *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼\n"
        " *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD\n"
        " * \n";

    string work(base_agreement);

        //CVSID̂̂
    time_t t;
    time(&t);

    work += string(" * @(#)$Id: ");
    work += filename;
    work += " ";
    work += static_cast<const char *>(asctime(localtime(&t)));
    
    work.erase(work.size() - 1);    //asctimeŉŝchomp

    work += " ";
    work += get_loginname();
    work += " Exp $\n */\n\n";

    return work;
}
#endif


/***************************************** eXgXB[g *****************************************/

#ifdef TESTSUITE

class SpecialtyFile_test : public ToppersJsp::SpecialtyFile
{
public:
    ~SpecialtyFile_test(void) throw() { TestSuite::check("SpecialtyFile::~SpecialtyFile"); }
    TESTSUITE_PROTOTYPE(main)
};

TESTSUITE(main, SpecialtyFile_test)
{
    BEGIN_CASE("constructor","constructor") {
        BEGIN_CASE("1","ROTɏ") {
            SpecialtyFile_test file;

            if(RuntimeObjectTable::getInstance<SpecialtyFile_test>() == 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","j̑ΏۂɂȂĂ") {
            Singleton<RuntimeObjectTable>::Context context;
            Singleton<RuntimeObjectTable>::saveContext(context);

            Singleton<RuntimeObjectTable>::renewInstance();

            new SpecialtyFile_test;

            TEST_CASE("0","[O] o^Ă", RuntimeObjectTable::getInstance<SpecialtyFile_test>() != 0);
            
            TestSuite::clearCheckpoints();
            Singleton<RuntimeObjectTable>::renewInstance(); //CX^X̍ĐROT폜

            TEST_CASE("1","ROTĂ", RuntimeObjectTable::getInstance<SpecialtyFile_test>() == 0);
            TEST_CASE("2","fXgN^NĂ", TestSuite::isReached("SpecialtyFile::~SpecialtyFile"));

            Singleton<RuntimeObjectTable>::restoreContext(context);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("createInstance","createInstance") {
        BEGIN_CASE("1","CX^Xł") {
            SpecialtyFile_test * file = SpecialtyFile::createInstance<SpecialtyFile_test>("test.txt");

            file->disableOutput();  //o͂Ă̂

            TEST_CASE("1","NULLԂ", file != 0);
            TEST_CASE("2","t@C",  file->getFilename().compare("test.txt") == 0);
        } END_CASE;

        BEGIN_CASE("2","󕶎nƗO") {

            bool result = false;
            try {
                SpecialtyFile::createInstance<SpecialtyFile_test>("");
            }
            catch(Exception &) {
                result = true;
            }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","IuWFNg͂Ȃ", RuntimeObjectTable::getInstance<SpecialtyFile_test>() == 0);
        } END_CASE;
    } END_CASE;
}

namespace {
    extern void testsuite(TestSuiteControl & _suite_control);
    TestSuite testsuite_onTop("TOPPERS/JSP Common Function(main)", testsuite);

            //eXgXB[g̖{
    void testsuite(TestSuiteControl & _suite_control)
    {
        Singleton<OptionParameter>::Context context;
        Singleton<OptionParameter>::saveContext(context);

        BEGIN_CASE("conv_includefile","conv_includefile") {
            BEGIN_CASE("1","-iltĂȂƃ_uNH[gł") {
                Singleton<OptionParameter>::renewInstance();

                if(ToppersJsp::conv_includefile("test.h").compare("\"test.h\"") != 0)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("1","-iltĂ<>ł") {
                Singleton<OptionParameter>::renewInstance();
                char * argv[] = {"test.exe","-il"};
                getOptionParameter().parseOption(2, argv);

                if(ToppersJsp::conv_includefile("test.h").compare("<test.h>") != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("conv_kernelobject","conv_kernelobject") {
            BEGIN_CASE("1","-1.3tĂȂ_kernel_t") {
                Singleton<OptionParameter>::renewInstance();

                if(ToppersJsp::conv_kernelobject("test").compare("_kernel_test") != 0)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("1","-1.3tĂƂ̂܂܏oĂ") {
                Singleton<OptionParameter>::renewInstance();
                char * argv[] = {"test.exe","-1.3"};
                getOptionParameter().parseOption(2, argv);

                if(ToppersJsp::conv_kernelobject("test").compare("test") != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        Singleton<OptionParameter>::restoreContext(context);

    }
}
#endif


