/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: kernel.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

#ifndef __KERNEL_H_
#define __KERNEL_H_

#include "resource.h"       // C V{
#include "devicemanagerCP.h"

/////////////////////////////////////////////////////////////////////////////
// CKernel
class ATL_NO_VTABLE CKernel : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CKernel, &CLSID_Kernel>,
	public IConnectionPointContainerImpl<CKernel>,
	public IKernel,
	public CProxy_IKernelEvents< CKernel >
{
public:
	CKernel();
	~CKernel();

DECLARE_REGISTRY_RESOURCEID(IDR_KERNEL)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CKernel)
	COM_INTERFACE_ENTRY(IKernel)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_CONNECTION_POINT_MAP(CKernel)
CONNECTION_POINT_ENTRY(IID__IKernelEvents)
END_CONNECTION_POINT_MAP()


// IKernel
public:
	STDMETHOD(OnLogEvent)(long sz, unsigned char data []);
	STDMETHOD(Write)(unsigned long address, unsigned long sz, unsigned char data[]);
	STDMETHOD(IsValid)(BOOL * valid);
	STDMETHOD(Read)(unsigned long address, unsigned long sz, unsigned char data[]);

	bool Valid;
};

#endif //__KERNEL_H_
