/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *  ^C}hCoiXstormy16pj
 */

#include <kernel.h>
#include <s_services.h>
#include <hw_timer.h>
#include <cpu_sfrs.h>

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
void hw_timer_initialize(void)
{
                                /*
                                 *  ^CeBbN̐ݒ
                                 */
    _kernel_tic_nume = 5u ;
                                /*
                                 *  RCMp5ms̊荞݂𔭐
                                 */
    __SFR_BITCLR( __OCR0, 4 ) ;         /* start internal-RC                 */
    __SFRW(__T0LR) = 5000-1 ;           /* Internl-RC is almost 1MHz,        */
                                        /*  so set 5000-1 for 5ms            */
    __SFR(__T0PR) = 0 ;                 /* Prescaler = 1/1                   */
    __SFR(__T0CNT) = 0x0d ;             /* Select internal-RC,               */
                                        /*  start timer and enable interrupt */
                                /*
                                 *  ftHg̃^C}[荞݃nho^
                                 */
    _kernel_define_inh( INHNO_TIMER, hw_timer_handler ) ;
                                /*
                                 *  ^C}[荞݂Level1ɐݒ
                                 */
    __SFR_BITCLR( __IL1L, 5 ) ;
    __SFR_BITSET( __IL1L, 4 ) ;
}

/*
 *  ^C}ݗṽNA
 */
void hw_timer_int_clear(void)
{
    __SFR_BITCLR( __T0CNT, 1 ) ;
}

/*
 *  ^C}̒~
 */
void hw_timer_terminate(void)
{
                                /*
                                 *  ^C}̓~D
                                 */
    __SFR(__T0CNT) = 0x00 ;
                                /*
                                 *  ^C}[荞݂֎~
                                 */
    __SFR_BITCLR( __IL1L, 5 ) ;
    __SFR_BITCLR( __IL1L, 4 ) ;
}

/*
 *  ftHg̃^C}݃nh
 */
void hw_timer_handler( void )
{
                                /*
                                 *  ^C}ݗṽNA
                                 */
    hw_timer_int_clear() ;
                                /*
                                 *  ^CeBbN̋
                                 */
    isig_tim();
}

