/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	^[Qbgˑ^C}W[iWindowspj
 */

#ifndef _HW_TIMER_C_
#define _HW_TIMER_C_

#include <s_services.h>
#include <hw_timer.h>
#include <hal_msg.h>

extern HANDLE PrimaryThreadHandle;

/*
 *  Windows̕W^C}
 */
#if defined(TIMER_WINDOWSTIMER)

	/* ^C}̋N */
void hw_timer_initialize()
{
    kprintf(("hw_timer_initialize()\n"));
	SetTimer((HWND)PrimaryThreadHandle,RTC_EVENT,TIMER_CLOCK_WINDOWS,NULL);
}

	/* ^C}̒~ */
void hw_timer_terminate()
{
    kprintf(("hw_timer_terminate()\n"));
	KillTimer((HWND)PrimaryThreadHandle,RTC_EVENT);
}


/*
 *  }`fBA^C}
 */
#elif defined(TIMER_MULTIMEDIATIMER)

#include <mmsystem.h>

static DWORD TimerID = 0;

static void CALLBACK MultiMediaTimerCallbackFunction(UINT wTimerID, UINT msg, DWORD dwUser, DWORD dw1, DWORD dw2)
{	HALInterruptRequest(INHNO_TIMER);	}

	/* ^C}̋N */
void hw_timer_initialize()
{
	MMRESULT result;
	TIMECAPS devcap;

    kprintf(("hw_timer_initialize()\n"));

    result = timeGetDevCaps(&devcap, sizeof(TIMECAPS));
	FatalAssertion(result == TIMERR_NOERROR &&  TIMER_CLOCK_WINDOWS >= devcap.wPeriodMin && TIMER_CLOCK_WINDOWS <= devcap.wPeriodMax, "w肳ꂽNbNeBbN̓}`fBA^C}Őݒ\Ȕ͈͂𒴂Ă܂B");

	timeBeginPeriod(TIMER_CLOCK_WINDOWS);	//timeBeginPeriod(devcap.wPeriodMin); ƎsƁAׂƈɐxオ

	TimerID = timeSetEvent(TIMER_CLOCK_WINDOWS, TIMER_CLOCK_WINDOWS,  MultiMediaTimerCallbackFunction, 0, TIME_PERIODIC|TIME_CALLBACK_FUNCTION);
	FatalAssertion(TimerID != 0, "hw_tiemr_initialize failed to perform 'timeSetEvent' function.");
}

	/* ^C}̒~ */
void hw_timer_terminate()
{
    kprintf(("hw_timer_terminate()\n"));

    if(TimerID != 0)
	{
		timeKillEvent(TimerID);
		timeEndPeriod(TIMER_CLOCK_WINDOWS);
	}
}

#elif defined(TIMER_NOTHING)

void hw_timer_initialize() {}
void hw_timer_terminate()  {}

#else

#error "gp^C}̎ʂIĂ܂"

#endif



#endif /* _HW_TIMER_H_ */

