/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hal_msg.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */


#ifndef __HAL_MSG_H
#define __HAL_MSG_H

#include <constants.h>
#include <t_services.h>
#include <vwindows.h>


#ifndef __HAL_MSG_MSGONLY

    /* OS̓ǗXbh̃nh */
extern HWND PrimaryDialogHandle;

    /* ǗXbhbNȂ߂SendMessage */
Inline void HALSendMessage(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    if(PrimaryDialogHandle != GetCurrentThread())
        SendMessage(PrimaryDialogHandle, uMsg, wParam, lParam);
    else
        PostMessage(PrimaryDialogHandle, uMsg, wParam, lParam);
}

    //fBXpb`˗
Inline void
HALDispatchRequest(void)
{   HALSendMessage(HALMSG_MESSAGE, HALMSG_DISPATCH, (LPARAM)0);   }

    //ReLXgj˗ ( : inlineAQƂĂꏊ͂ЂƂȂ̂ł̂܂܂ɂ)
Inline void
HALDestroyRequest(void * tcb)
{	PostMessage(PrimaryDialogHandle,HALMSG_MESSAGE,HALMSG_DESTROY,(LPARAM)tcb);   }

    //݈˗ (intno : ݔԍ)
Inline void
HALInterruptRequest(unsigned int intno)
{	PostMessage(PrimaryDialogHandle,HALMSG_MESSAGE,HALMSG_INTERRUPT,(LPARAM)intno);   }

    //ݏʒm
Inline void
HALInterruptRequestAndWait(void)
{
	SendMessage(PrimaryDialogHandle,HALMSG_MESSAGE,HALMSG_INTERRUPT_FINISH,(LPARAM)0);
}

    //Cӂ̃[`̎sv
Inline BOOL
HALExecuteProcedure(void * func, void * param)
{
	void * _workofHALExecuteProcedure[2];
	
	if(func == NULL)
		return FALSE;

	_workofHALExecuteProcedure[0] = func;
	_workofHALExecuteProcedure[1] = param;
	HALSendMessage(HALMSG_MESSAGE,HALMSG_EXECUTEPROCEDURE,(LPARAM)_workofHALExecuteProcedure);

	return TRUE;
}

    //j`F[Ɋ֐o^
Inline BOOL
HALAddDestructionProcedure(void * func, void * param)
{
	void * _workofHALAddDestructionProcedure[2];

	if(func == NULL)
		return FALSE;

	_workofHALAddDestructionProcedure[0] = func;
	_workofHALAddDestructionProcedure[1] = param;
    HALSendMessage(HALMSG_MESSAGE,HALMSG_ADDDESTRUCTIONPROCEDURE,(LPARAM)_workofHALAddDestructionProcedure);

	return TRUE;
}

    //J[l̏Iv
Inline void
HALQuitRequest(void)
{
    HALSendMessage(HALMSG_MESSAGE,HALMSG_QUITREQUEST,0);
}

#endif

#endif

/***/