/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */


/*
 *	vZbTˑW[iWindowspj
 */
#include <cpu_rename.h>

#include <s_services.h>

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

#include <hal_msg.h>

volatile char CPUStatus = CPU_STAT_LOCK;	//CPUԃtO

/*
 *  ^XNfBXpb`
 *    fBXpb`{̂primary_thread.cɂ
 *    ł͊ǗXbhɃfBXpb`˗o
 */
void
dispatch()
{
	LOG_DSP_ENTER_TSK(runtsk);
	HALDispatchRequest();	
}

/* ݗpfBXpb` (o͂郍Ô݂قȂ) */
void
idispatch()
{
	LOG_DSP_ENTER_INT(runtsk);
	HALDispatchRequest();
}


/*
 *  ݂̃ReLXĝĂăfBXpb`
 *    exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 *
 *    ݎs̃^XNTCBw肵Ĕj˗Bj㎩IɃfBXpb`ցB
 */
void
exit_and_dispatch() 
{
    HANDLE handle;

	HALDestroyRequest(runtsk);

    if((handle = (HANDLE)TlsGetValue(TLS_THREADHANDLE)) != NULL)
        CloseHandle(handle);

    TlsFree(TLS_THREADHANDLE);
    TlsFree(TLS_LOGMASK);

	ExitThread(0);
}


/*
 *  vZbTˑ̏
 */

void
cpu_initialize()
{
    kprintf(("cpu_initialize()\n"));

	/*
	 *  ݃G~[^̏
	 */
	ini_int();

	/*
	 * ŏʍ\Onh̐ݒ
	 */
	ini_exc();
}

/*
 *  vZbTˑ̏I
 */
void
cpu_terminate()
{
    kprintf(("cpu_terminate()\n"));

    fin_int();  //݃G~[^̒~
	fin_exc();  //ŏʍ\Onh̉
}


/*
 * ^XNN[`
 *
 */

DWORD WINAPI
activate_r( LPVOID param)
{
	TCB * tcb = (TCB *)param;

	TlsAlloc();
	TlsSetValue(TLS_LOGMASK, 0);
    TlsSetValue(TLS_THREADHANDLE, tcb->tskctxb.ThreadHandle);

    kprintf(("Task %d : activated\n", (tcb - tcb_table) + 1));

	(*(void(*)(VP_INT))tcb->tinib->task)(tcb->tinib->exinf);
	ext_tsk();
	return 0;
}

/*
 *  atexitœo^ꂽ֐̓Ǐo (Windows͉Ȃ -> CRTɔC)
 */
void call_atexit(void)
{}


/*
 *   vIȎsɑ΂Ώ[`
 */
void FatalAssertion(int exp, LPCSTR format, ...)
{
	extern HANDLE PrimaryThreadHandle;
	extern HANDLE CurrentRunningThreadHandle;

	if(!exp)
	{
		va_list vl;
		char    buffer[1024];

			/* G[N˂~߂ */
		wsprintf(buffer, "Critical assertion fail occured !!\nGetLastError = 0x%08x\n\n", GetLastError());

			/* J[loĂ... */		
		if(PrimaryThreadHandle != NULL)
		{
				/* J[l̎s~߂ */
			dis_int(0);
			if(CurrentRunningThreadHandle != NULL)
				SuspendThread(CurrentRunningThreadHandle);
			hw_timer_terminate();
		}

			/* x\ */
		va_start(vl, format);
		wvsprintf(buffer + lstrlen(buffer), format, vl);
		MessageBox(PrimaryDialogHandle, buffer, "Assertion Failed", MB_OK|MB_ICONERROR);

			/* J[l~ */
		HALQuitRequest();
	}
}

	/*
	 *   Oo͂ǂ邩̐
	 */
void set_logcontrol(BOOL enable)
{
	BOOL result;
	result = TlsSetValue(TLS_LOGMASK, (LPVOID)(enable == TRUE ? 0 : 1));
	if(result == 0)
	{
		TlsAlloc();
		TlsSetValue(TLS_LOGMASK, (LPVOID)(enable == TRUE ? 0 : 1));
	}
}

    /*
     *   J[l̃fobOpprintf
     */
void _kernel_debugprintf(const char * format, ... )
{
    va_list vl;
    int     words;
    DWORD   count;
    char    buffer[1024];

    va_start(vl, format);
    words = wvsprintf(buffer, format, vl);

    if(words != 0)
        WriteFile(GetStdHandle(STD_OUTPUT_HANDLE), buffer, words, &count, NULL);
}

#ifdef _MSC_VER     //cygwin̏ꍇcpu_insn.SɋLq

 /*
  * ^XNON[`
  *   ReLXgv邽߁A
  *   ^XNO𓮂^XÑXbhœ삳邽߂̃[`
  */
void __declspec(naked) TaskExceptionPerformer(void)
{
		/* WX^ޔ */
	__asm	pusha
	__asm	sub		esp, FPU_CONTEXTSIZE
	__asm	fsave	[esp]

		/* ^XNŐN */
	__asm	call	call_texrtn

		/* ݃}XN߂ */
	__asm	mov		ebx, DWORD PTR runtsk
	__asm	mov		eax, [ebx]TCB.tskctxb.InterruptLevel
	__asm	push	eax
	__asm	call	chg_ims
	__asm	add		esp, 4

		/* WX^A */
	__asm	finit
	__asm	frstor	[esp]
	__asm	add		esp, FPU_CONTEXTSIZE
	__asm	popa
	__asm	ret
}

#endif

