/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	^[Qbgˑ^C}W[iV850ES/KJ1+^C}0-ch0(TM00)pj
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

#ifndef _MACRO_ONLY

/* VXe^C}[TM00gp */
#define	TIMER_INT_PRIORITY		0		/* 荞ݗDx(0ō7Œ) */
#define	TIMER_COMPAREVALUE		((CPU_CLOCK>>1)/1000)		/* fx/21msec */


#define WAIT __asm("nop;nop;nop;nop");

/*
 *  ^C}݃nh̃xN^ԍ
 */
#define	INHNO_TIMER	       (0x10)

/*
 *  ^C}l̓\̌^
 */
typedef UW	CLOCK;

#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize(void)
{
	/* ^C} */
	sil_wrb_mem((VP)PRM00, 0);		/* fx/2 */
	sil_wrh_mem((VP)CR000, TIMER_COMPAREVALUE);
	sil_wrb_mem((VP)CRC00, 4);			/* CR0x0Lv` */
	sil_wrb_mem((VP)TMC00, 0x0c);		/* Lv`Clear&Start */

	/* ݗvA݋ɂāADxݒ肷 */
	sil_wrb_mem((VP)TM0IC00, TIMER_INT_PRIORITY);
}

/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear(void)
{
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
hw_timer_terminate(void)
{
	/* ݂}XN */
	sil_wrb_mem((VP)TM0IC00, sil_reb_mem((VP)TM0IC00) | 0x40);
}

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return sil_reb_mem((VP)TM00);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return (sil_reb_mem((VP)TM0IC00) & 0x80) != 0;
}

#endif /* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
