/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 * ^[QbgˑVAI/OW[iV850/KJ1+ 񓯊VAch0/ch1pj
 *   {[[gݒSERIAL_COMPAREVALUEύXB
 *   f[^tH[}bg8bit data, non-parity, 1stop-bitŒ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

/*
 *  VA|[g̏ubN
 */

typedef struct sio_port_initialization_block {
} SIOPINIB;

/*
 *  VA|[g̐ubN
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*inib;		/* ubN	*/
	VP_INT		exinf;		/* g		*/
	BOOL		openflag;	/* I[vς݃tO	*/
	int			port_id;	/* |[gԍ(0`) */
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ǗubNւ̕ϊ}N
 */

#define INDEX_SIO(sioid)	((UINT)((sioid) - 1))
#define get_siopcb(sioid)	(&(siopcb_table[INDEX_SIO(sioid)]))

/*
 *  R[obN[`̎ʔԍ
 */

#define SIO_ERDY_SND		1u			/* M\R[obN			*/
#define SIO_ERDY_RCV		2u			/* MʒmR[obN			*/

/*
 *  VA|[g̃n[hEFAˑ̒`
 */

#define SERIAL_PORT				(CONSOLE_PORTID-1)		/* VXẽ|[gԍ */
#define SERIAL_INT_PRIORITY		1	/* 荞ݗDx */
#define SERIAL_CLKDIV			3	/* clk = fxx/8     */
#define SERIAL_COMPAREVALUE		11	/* 9600bps=130, 19200bps=65, 38400bps=33, 57600bps=22, 115200bps=11 */

/* VA֘AWX^ */
#define ASIM(x)  (ASIM0 + ((x) * 0x10))
#define ASIS(x)  (ASIS0 + ((x) * 0x10))
#define ASIF(x)  (ASIF0 + ((x) * 0x10))
#define RXB(x)   (RXB0  + ((x) * 0x10))
#define TXB(x)   (TXB0  + ((x) * 0x10))
#define CKSR(x)  (CKSR0 + ((x) * 0x10))
#define BRGC(x)  (BRGC0 + ((x) * 0x10))
#define SRIC(x)  (SRIC0 + ((x) * 8))
#define STIC(x)  (STIC0 + ((x) * 8))

/*
 *  VAI/O̊݃nh̃xN^ԍ
 */
#define INHNO_SERIAL_IN		(0x19 + (SERIAL_PORT * 3))
#define INHNO_SERIAL_OUT	(0x1a + (SERIAL_PORT * 3))

/*
 *  ჌x|[gǗubN̏l
 */

#define NUM_PORT	1	/* T|[gVA|[g̐ */

#define FLG_RECEIVED 1
#define FLG_TXRBUSY  2

extern unsigned int _serial_flag[TNUM_PORT];

/*
 *  VAI/O|[g̏
 */
Inline BOOL
hw_port_initialize(int port_id)
{
	if( (sil_reb_mem((VP)ASIM(port_id)) & 0x80) == 0 )
	{
	    	/* 񓯊VAʐMH̏ */

		/* |[gJ */
		if (port_id == 0) {
			sil_wrh_mem((VP)PMC3, sil_reh_mem((VP)PMC3) | 0x0003);
		} else {
			sil_wrh_mem((VP)PFC8, 0);
			sil_wrh_mem((VP)PMC8, 3);
		}
		/* {[[g̏ */
		sil_wrb_mem((VP)CKSR(port_id), SERIAL_CLKDIV);
		sil_wrb_mem((VP)BRGC(port_id), SERIAL_COMPAREVALUE);
		sil_wrb_mem((VP)ASIM(port_id), sil_reb_mem((VP)ASIM(port_id)) | 0x80);	/* enable ASIO */

		__asm("nop; nop");

		sil_wrb_mem((VP)ASIM(port_id), sil_reb_mem((VP)ASIM(port_id)) | 0x04);	/* 8bit length */

		__asm("nop; nop");

		sil_wrb_mem((VP)ASIM(port_id), sil_reb_mem((VP)ASIM(port_id)) | 0x60);	/* Tx, Rx enable */

		/* ݐ */
		sil_wrb_mem((VP)SRIC(port_id), SERIAL_INT_PRIORITY);
		sil_wrb_mem((VP)STIC(port_id), SERIAL_INT_PRIORITY);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̏I
 */
Inline void
hw_port_terminate(int port_id)
{
}

/*
 *  VA|[g݃T[rX[`iOQƁj
 */
extern void	serial_handler_in(int portid);
extern void	serial_handler_out(int portid);

/*
 *  MH
 */
Inline BOOL
hw_port_getready(int port_id)
{
	return (_serial_flag[port_id] & FLG_RECEIVED) != 0 ? TRUE : FALSE;
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
hw_port_putready(int port_id)
{
	return (sil_reb_mem((VP)ASIF(port_id)) & FLG_TXRBUSY) != 0 ? FALSE : TRUE;
}

/*
 *  M̎o
 */
Inline unsigned char
hw_port_getchar(int port_id)
{
	_serial_flag[port_id] &= ~FLG_RECEIVED;
	sil_wrb_mem((VP)SRIC(port_id), sil_reb_mem((VP)SRIC(port_id)) & 0x7f);
	return sil_reb_mem((VP)RXB(port_id));
}

/*
 *  M镶̏
 */
Inline void
hw_port_putchar(int port_id, unsigned char c)
{
	sil_wrb_mem((VP)TXB(port_id), c);
	_serial_flag[port_id] |= FLG_TXRBUSY;
}

/*
 *  M镶̏݁iM\ɂȂ܂ő҂j
 */
Inline void
hw_port_wait_putchar(int port_id, unsigned char c)
{
	while( !hw_port_putready(port_id) ) ;
	hw_port_putchar(port_id, c);
}

/*
 *  M֐
 */
Inline void
hw_port_sendstart(int port_id)
{
}

Inline void
hw_port_sendstop(int port_id)
{
}

extern void	sio_ierdy_rcv(VP_INT exinf);
extern void	sio_ierdy_snd(VP_INT exinf);

Inline void
hw_port_handler_in(int port_id)
{
	_serial_flag[port_id] |= FLG_RECEIVED;
    sio_ierdy_rcv(siopcb_table[port_id].exinf);
}

Inline void
hw_port_handler_out(int port_id)
{
	_serial_flag[port_id] &= ~FLG_TXRBUSY;
	sio_ierdy_snd(siopcb_table[port_id].exinf);
}

/***********************************************************************************/

/*
 *  sio_initialize -- VA|[ghCȍ
 */
Inline void
sio_initialize (void)
{
	int ix;

	/* SIO ǗubN̏ */
	for (ix = TNUM_PORT; ix -- > 0; ) {
		siopcb_table[ix].openflag = FALSE;
	}
}

/*
 *  sio_opn_por -- |[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID sioid, VP_INT exinf)
{
	SIOPCB	*pcb;

	pcb = get_siopcb(sioid);
	pcb->inib     = NULL;
	pcb->exinf    = exinf;
	pcb->openflag = TRUE;
	pcb->port_id  = sioid-1;
	hw_port_initialize(pcb->port_id);
	return pcb;
}

/*
 *  sio_snd_chr -- M
 */
Inline BOOL
sio_snd_chr(SIOPCB *pcb, INT chr)
{
	if (hw_port_putready(pcb->port_id)) {
		hw_port_putchar(pcb->port_id, (UB)chr);
		return TRUE;
		}
	else
		return FALSE;
}

/*
 *  sio_rcv_chr -- M
 */
Inline INT
sio_rcv_chr(SIOPCB *pcb)
{
	if (hw_port_getready(pcb->port_id))
		return hw_port_getchar(pcb->port_id);
	else
		return -1;
}

/*
 *  sio_ena_cbr -- VA I/O ̃R[obN̋
 */
Inline void
sio_ena_cbr(SIOPCB *pcb, UINT cbrtn)
{
}

/*
 *  sio_dis_cbr -- VA I/O ̃R[obN̋֎~
 */
Inline void
sio_dis_cbr(SIOPCB *pcb, UINT cbrtn)
{
}

/*
 *  sio_cls_por -- |[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *pcb)
{
	sio_dis_cbr(pcb, SIO_ERDY_SND);
	sio_dis_cbr(pcb, SIO_ERDY_RCV);
	pcb->openflag = FALSE;
}

Inline void
sio_in_handler(void)
{
	hw_port_handler_in(0);
}

Inline void
sio_out_handler(void)
{
	hw_port_handler_out(0);
}

#if TNUM_PORT > 1
Inline void
sio_in_handler2(void)
{
	hw_port_handler_in(1);
}

Inline void
sio_out_handler2(void)
{
	hw_port_handler_out(1);
}
#endif

#endif /* _HW_SERIAL_H_ */
